/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.SuffixBasedNodeLocator;
import de.javakaffee.web.msm.TranscoderWrapperStatisticsSupport;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.List;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.protocol.binary.BinaryMemcachedNodeImpl;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;

public final class SuffixLocatorBinaryConnectionFactory
extends DefaultConnectionFactory {
    private final MemcachedNodesManager _memcachedNodesManager;
    private final SessionIdFormat _sessionIdFormat;
    private final Statistics _statistics;
    private final long _operationTimeout;
    private final long _maxReconnectDelay;
    private final AuthDescriptor _authDescriptor;

    public SuffixLocatorBinaryConnectionFactory(MemcachedNodesManager memcachedNodesManager, SessionIdFormat sessionIdFormat, Statistics statistics, long operationTimeout, long maxReconnectDelay, AuthDescriptor authDescriptor) {
        this._memcachedNodesManager = memcachedNodesManager;
        this._sessionIdFormat = sessionIdFormat;
        this._statistics = statistics;
        this._operationTimeout = operationTimeout;
        this._maxReconnectDelay = maxReconnectDelay;
        this._authDescriptor = authDescriptor;
    }

    public SuffixLocatorBinaryConnectionFactory(MemcachedNodesManager memcachedNodesManager, SessionIdFormat sessionIdFormat, Statistics statistics, long operationTimeout, long maxReconnectDelay) {
        this(memcachedNodesManager, sessionIdFormat, statistics, operationTimeout, maxReconnectDelay, null);
    }

    @Override
    public FailureMode getFailureMode() {
        return FailureMode.Cancel;
    }

    @Override
    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return new SuffixBasedNodeLocator(nodes, this._memcachedNodesManager, this._sessionIdFormat);
    }

    @Override
    public Transcoder<Object> getDefaultTranscoder() {
        SerializingTranscoder transcoder = new SerializingTranscoder();
        transcoder.setCompressionThreshold(16384);
        return new TranscoderWrapperStatisticsSupport(this._statistics, transcoder);
    }

    @Override
    public MemcachedNode createMemcachedNode(SocketAddress sa, SocketChannel c, int bufSize) {
        boolean doAuth = this._authDescriptor != null;
        long defaultOpTimeout = this.getOperationTimeout();
        return new BinaryMemcachedNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue(), (Long)this.getOpQueueMaxBlockTime(), doAuth, defaultOpTimeout, this.getAuthWaitTime(), (ConnectionFactory)this);
    }

    @Override
    public OperationFactory getOperationFactory() {
        return new BinaryOperationFactory();
    }

    @Override
    public long getOperationTimeout() {
        return this._operationTimeout;
    }

    @Override
    public long getMaxReconnectDelay() {
        return this._maxReconnectDelay;
    }

    @Override
    public AuthDescriptor getAuthDescriptor() {
        return this._authDescriptor;
    }
}

