/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.RedisResponseTimeoutException;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.TransferListener;

public class RedissonMultiLock
implements Lock {
    final List<RLock> locks = new ArrayList<RLock>();

    public RedissonMultiLock(RLock ... locks) {
        if (locks.length == 0) {
            throw new IllegalArgumentException("Lock objects are not defined");
        }
        this.locks.addAll(Arrays.asList(locks));
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lockInterruptibly(leaseTime, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
        long baseWaitTime = this.locks.size() * 1500;
        long waitTime = -1L;
        if (leaseTime == -1L) {
            waitTime = baseWaitTime;
            unit = TimeUnit.MILLISECONDS;
        } else {
            waitTime = unit.toMillis(leaseTime);
            waitTime = waitTime <= 2000L ? 2000L : (waitTime <= baseWaitTime ? ThreadLocalRandom.current().nextLong(waitTime / 2L, waitTime) : ThreadLocalRandom.current().nextLong(baseWaitTime, waitTime));
            waitTime = unit.convert(waitTime, TimeUnit.MILLISECONDS);
        }
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        this.tryLockAsync(leaseTime, unit, waitTime, result);
        return result;
    }

    protected void tryLockAsync(final long leaseTime, final TimeUnit unit, final long waitTime, final RPromise<Void> result) {
        this.tryLockAsync(waitTime, leaseTime, unit).addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    result.trySuccess(null);
                } else {
                    RedissonMultiLock.this.tryLockAsync(leaseTime, unit, waitTime, result);
                }
            }
        });
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(-1L, null);
    }

    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        long baseWaitTime = this.locks.size() * 1500;
        long waitTime = -1L;
        if (leaseTime == -1L) {
            waitTime = baseWaitTime;
            unit = TimeUnit.MILLISECONDS;
        } else {
            waitTime = unit.toMillis(leaseTime);
            waitTime = waitTime <= 2000L ? 2000L : (waitTime <= baseWaitTime ? ThreadLocalRandom.current().nextLong(waitTime / 2L, waitTime) : ThreadLocalRandom.current().nextLong(baseWaitTime, waitTime));
            waitTime = unit.convert(waitTime, TimeUnit.MILLISECONDS);
        }
        while (!this.tryLock(waitTime, leaseTime, unit)) {
        }
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(-1L, -1L, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    protected void unlockInner(Collection<RLock> locks) {
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>(locks.size());
        for (RLock rLock : locks) {
            futures.add(rLock.unlockAsync());
        }
        for (RFuture rFuture : futures) {
            rFuture.awaitUninterruptibly();
        }
    }

    protected RFuture<Void> unlockInnerAsync(Collection<RLock> locks, long threadId) {
        if (locks.isEmpty()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        final AtomicInteger counter = new AtomicInteger(locks.size());
        for (RLock lock : locks) {
            lock.unlockAsync(threadId).addListener(new FutureListener<Void>(){

                @Override
                public void operationComplete(Future<Void> future) throws Exception {
                    if (!future.isSuccess()) {
                        result.tryFailure(future.cause());
                        return;
                    }
                    if (counter.decrementAndGet() == 0) {
                        result.trySuccess(null);
                    }
                }
            });
        }
        return result;
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    protected int failedLocksLimit() {
        return 0;
    }

    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long newLeaseTime = -1L;
        if (leaseTime != -1L) {
            newLeaseTime = unit.toMillis(waitTime) * 2L;
        }
        long time = System.currentTimeMillis();
        long remainTime = -1L;
        if (waitTime != -1L) {
            remainTime = unit.toMillis(waitTime);
        }
        long lockWaitTime = this.calcLockWaitTime(remainTime);
        int failedLocksLimit = this.failedLocksLimit();
        ArrayList<RLock> acquiredLocks = new ArrayList<RLock>(this.locks.size());
        ListIterator<RLock> iterator = this.locks.listIterator();
        while (iterator.hasNext()) {
            boolean bl;
            RLock lock = iterator.next();
            try {
                if (waitTime == -1L && leaseTime == -1L) {
                    bl = lock.tryLock();
                } else {
                    long awaitTime = Math.min(lockWaitTime, remainTime);
                    bl = lock.tryLock(awaitTime, newLeaseTime, TimeUnit.MILLISECONDS);
                }
            }
            catch (RedisResponseTimeoutException e) {
                this.unlockInner(Arrays.asList(lock));
                bl = false;
            }
            catch (Exception e) {
                bl = false;
            }
            if (bl) {
                acquiredLocks.add(lock);
            } else {
                if (this.locks.size() - acquiredLocks.size() == this.failedLocksLimit()) break;
                if (failedLocksLimit == 0) {
                    this.unlockInner(acquiredLocks);
                    if (waitTime == -1L && leaseTime == -1L) {
                        return false;
                    }
                    failedLocksLimit = this.failedLocksLimit();
                    acquiredLocks.clear();
                    while (iterator.hasPrevious()) {
                        iterator.previous();
                    }
                } else {
                    --failedLocksLimit;
                }
            }
            if (remainTime == -1L) continue;
            time = System.currentTimeMillis();
            if ((remainTime -= System.currentTimeMillis() - time) > 0L) continue;
            this.unlockInner(acquiredLocks);
            return false;
        }
        if (leaseTime != -1L) {
            ArrayList<RFuture<Boolean>> futures = new ArrayList<RFuture<Boolean>>(acquiredLocks.size());
            for (RLock rLock : acquiredLocks) {
                RFuture<Boolean> future = rLock.expireAsync(unit.toMillis(leaseTime), TimeUnit.MILLISECONDS);
                futures.add(future);
            }
            for (RFuture rFuture : futures) {
                rFuture.syncUninterruptibly();
            }
        }
        return true;
    }

    private void tryAcquireLockAsync(final ListIterator<RLock> iterator, final List<RLock> acquiredLocks, final RPromise<Boolean> result, final long lockWaitTime, final long waitTime, final long leaseTime, final long newLeaseTime, final AtomicLong remainTime, final AtomicLong time, final AtomicInteger failedLocksLimit, final TimeUnit unit, final long threadId) {
        if (!iterator.hasNext()) {
            this.checkLeaseTimeAsync(acquiredLocks, result, leaseTime, unit);
            return;
        }
        final RLock lock = iterator.next();
        RedissonPromise lockAcquired = new RedissonPromise();
        if (waitTime == -1L && leaseTime == -1L) {
            lock.tryLockAsync(threadId).addListener(new TransferListener(lockAcquired));
        } else {
            long awaitTime = Math.min(lockWaitTime, remainTime.get());
            lock.tryLockAsync(awaitTime, newLeaseTime, TimeUnit.MILLISECONDS, threadId).addListener(new TransferListener(lockAcquired));
        }
        lockAcquired.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                boolean lockAcquired = false;
                if (future.getNow() != null) {
                    lockAcquired = future.getNow();
                }
                if (future.cause() instanceof RedisResponseTimeoutException) {
                    RedissonMultiLock.this.unlockInnerAsync(Arrays.asList(lock), threadId);
                }
                if (lockAcquired) {
                    acquiredLocks.add(lock);
                } else {
                    if (RedissonMultiLock.this.locks.size() - acquiredLocks.size() == RedissonMultiLock.this.failedLocksLimit()) {
                        RedissonMultiLock.this.checkLeaseTimeAsync(acquiredLocks, result, leaseTime, unit);
                        return;
                    }
                    if (failedLocksLimit.get() == 0) {
                        RedissonMultiLock.this.unlockInnerAsync(acquiredLocks, threadId).addListener(new FutureListener<Void>(){

                            @Override
                            public void operationComplete(Future<Void> future) throws Exception {
                                if (!future.isSuccess()) {
                                    result.tryFailure(future.cause());
                                    return;
                                }
                                if (waitTime == -1L && leaseTime == -1L) {
                                    result.trySuccess(false);
                                    return;
                                }
                                failedLocksLimit.set(RedissonMultiLock.this.failedLocksLimit());
                                acquiredLocks.clear();
                                while (iterator.hasPrevious()) {
                                    iterator.previous();
                                }
                                RedissonMultiLock.this.checkRemainTimeAsync(iterator, acquiredLocks, result, lockWaitTime, waitTime, leaseTime, newLeaseTime, remainTime, time, failedLocksLimit, unit, threadId);
                            }
                        });
                        return;
                    }
                    failedLocksLimit.decrementAndGet();
                }
                RedissonMultiLock.this.checkRemainTimeAsync(iterator, acquiredLocks, result, lockWaitTime, waitTime, leaseTime, newLeaseTime, remainTime, time, failedLocksLimit, unit, threadId);
            }
        });
    }

    private void checkLeaseTimeAsync(List<RLock> acquiredLocks, final RPromise<Boolean> result, long leaseTime, TimeUnit unit) {
        if (leaseTime != -1L) {
            final AtomicInteger counter = new AtomicInteger(this.locks.size());
            for (RLock rLock : acquiredLocks) {
                RFuture<Boolean> future = rLock.expireAsync(unit.toMillis(leaseTime), TimeUnit.MILLISECONDS);
                future.addListener(new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        if (counter.decrementAndGet() == 0) {
                            result.trySuccess(true);
                        }
                    }
                });
            }
            return;
        }
        result.trySuccess(true);
    }

    protected void checkRemainTimeAsync(ListIterator<RLock> iterator, List<RLock> acquiredLocks, final RPromise<Boolean> result, long lockWaitTime, long waitTime, long leaseTime, long newLeaseTime, AtomicLong remainTime, AtomicLong time, AtomicInteger failedLocksLimit, TimeUnit unit, long threadId) {
        if (remainTime.get() != -1L) {
            remainTime.addAndGet(-(System.currentTimeMillis() - time.get()));
            time.set(System.currentTimeMillis());
            if (remainTime.get() <= 0L) {
                this.unlockInnerAsync(acquiredLocks, threadId).addListener(new FutureListener<Void>(){

                    @Override
                    public void operationComplete(Future<Void> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        result.trySuccess(false);
                    }
                });
                return;
            }
        }
        this.tryAcquireLockAsync(iterator, acquiredLocks, result, lockWaitTime, waitTime, leaseTime, newLeaseTime, remainTime, time, failedLocksLimit, unit, threadId);
    }

    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        long newLeaseTime = -1L;
        if (leaseTime != -1L) {
            newLeaseTime = unit.toMillis(waitTime) * 2L;
        }
        AtomicLong time = new AtomicLong(System.currentTimeMillis());
        AtomicLong remainTime = new AtomicLong(-1L);
        if (waitTime != -1L) {
            remainTime.set(unit.toMillis(waitTime));
        }
        long lockWaitTime = this.calcLockWaitTime(remainTime.get());
        AtomicInteger failedLocksLimit = new AtomicInteger(this.failedLocksLimit());
        ArrayList<RLock> acquiredLocks = new ArrayList<RLock>(this.locks.size());
        long threadId = Thread.currentThread().getId();
        this.tryAcquireLockAsync(this.locks.listIterator(), acquiredLocks, result, lockWaitTime, waitTime, leaseTime, newLeaseTime, remainTime, time, failedLocksLimit, unit, threadId);
        return result;
    }

    protected long calcLockWaitTime(long remainTime) {
        return remainTime;
    }

    public RFuture<Void> unlockAsync(long threadId) {
        return this.unlockInnerAsync(this.locks, threadId);
    }

    @Override
    public void unlock() {
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>(this.locks.size());
        for (RLock rLock : this.locks) {
            futures.add(rLock.unlockAsync());
        }
        for (RFuture rFuture : futures) {
            rFuture.syncUninterruptibly();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }
}

