/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.mixed;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.annotations.Experimental;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.operators.mixed.ScalarXMapZHelper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@Experimental
public final class ObservableConcatMapSingle<T, R>
extends Observable<R> {
    final Observable<T> source;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;
    final ErrorMode errorMode;
    final int prefetch;

    public ObservableConcatMapSingle(Observable<T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper, ErrorMode errorMode, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(Observer<? super R> s) {
        if (!ScalarXMapZHelper.tryAsSingle(this.source, this.mapper, s)) {
            this.source.subscribe(new ConcatMapSingleMainObserver<T, R>(s, this.mapper, this.prefetch, this.errorMode));
        }
    }

    static final class ConcatMapSingleMainObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -9140123220065488293L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends SingleSource<? extends R>> mapper;
        final AtomicThrowable errors;
        final ConcatMapSingleObserver<R> inner;
        final SimplePlainQueue<T> queue;
        final ErrorMode errorMode;
        Disposable upstream;
        volatile boolean done;
        volatile boolean cancelled;
        R item;
        volatile int state;
        static final int STATE_INACTIVE = 0;
        static final int STATE_ACTIVE = 1;
        static final int STATE_RESULT_VALUE = 2;

        ConcatMapSingleMainObserver(Observer<? super R> downstream, Function<? super T, ? extends SingleSource<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.errorMode = errorMode;
            this.errors = new AtomicThrowable();
            this.inner = new ConcatMapSingleObserver(this);
            this.queue = new SpscLinkedArrayQueue(prefetch);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.errors.addThrowable(t)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.inner.dispose();
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.inner.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
                this.item = null;
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void innerSuccess(R item) {
            this.item = item;
            this.state = 2;
            this.drain();
        }

        void innerError(Throwable ex) {
            if (this.errors.addThrowable(ex)) {
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.dispose();
                }
                this.state = 0;
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<R> downstream = this.downstream;
            ErrorMode errorMode = this.errorMode;
            SimplePlainQueue<T> queue = this.queue;
            AtomicThrowable errors = this.errors;
            while (true) {
                if (this.cancelled) {
                    queue.clear();
                    this.item = null;
                }
                int s = this.state;
                if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && s == 0)) {
                    queue.clear();
                    this.item = null;
                    Throwable ex = errors.terminate();
                    downstream.onError(ex);
                    return;
                }
                if (s == 0) {
                    boolean empty;
                    boolean d = this.done;
                    T v = queue.poll();
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        Throwable ex = errors.terminate();
                        if (ex == null) {
                            downstream.onComplete();
                        } else {
                            downstream.onError(ex);
                        }
                        return;
                    }
                    if (!empty) {
                        SingleSource<R> ss;
                        try {
                            ss = ObjectHelper.requireNonNull(this.mapper.apply(v), "The mapper returned a null SingleSource");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.upstream.dispose();
                            queue.clear();
                            errors.addThrowable(ex);
                            ex = errors.terminate();
                            downstream.onError(ex);
                            return;
                        }
                        this.state = 1;
                        ss.subscribe(this.inner);
                    }
                } else if (s == 2) {
                    R w = this.item;
                    this.item = null;
                    downstream.onNext(w);
                    this.state = 0;
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class ConcatMapSingleObserver<R>
        extends AtomicReference<Disposable>
        implements SingleObserver<R> {
            private static final long serialVersionUID = -3051469169682093892L;
            final ConcatMapSingleMainObserver<?, R> parent;

            ConcatMapSingleObserver(ConcatMapSingleMainObserver<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onSuccess(R t) {
                this.parent.innerSuccess(t);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

