/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.redisson.RedissonMap;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.MapScanResult;
import reactor.core.publisher.FluxSink;

public class MapReactiveIterator<K, V, M>
implements Consumer<FluxSink<M>> {
    private final RedissonMap<K, V> map;
    private final String pattern;
    private final int count;

    public MapReactiveIterator(RedissonMap<K, V> map, String pattern, int count) {
        this.map = map;
        this.pattern = pattern;
        this.count = count;
    }

    @Override
    public void accept(final FluxSink<M> emitter) {
        emitter.onRequest(new LongConsumer(){
            private long nextIterPos;
            private RedisClient client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            @Override
            public void accept(long value) {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues(emitter);
                    this.completed = false;
                }
            }

            protected void nextValues(final FluxSink<M> emitter2) {
                MapReactiveIterator.this.scanIterator(this.client, this.nextIterPos).addListener(new FutureListener<MapScanResult<Object, Object>>(){

                    @Override
                    public void operationComplete(Future<MapScanResult<Object, Object>> future) throws Exception {
                        if (!future.isSuccess()) {
                            emitter2.error(future.cause());
                            return;
                        }
                        if (finished) {
                            client = null;
                            nextIterPos = 0L;
                            return;
                        }
                        MapScanResult<Object, Object> res = future.getNow();
                        client = res.getRedisClient();
                        nextIterPos = res.getPos();
                        for (Map.Entry<Object, Object> entry : res.getMap().entrySet()) {
                            Object val = MapReactiveIterator.this.getValue(entry);
                            emitter2.next(val);
                            elementsRead.incrementAndGet();
                        }
                        if (elementsRead.get() >= readAmount.get()) {
                            emitter2.complete();
                            elementsRead.set(0L);
                            completed = true;
                            return;
                        }
                        if (res.getPos() == 0L && !MapReactiveIterator.this.tryAgain()) {
                            finished = true;
                            emitter2.complete();
                        }
                        if (finished || completed) {
                            return;
                        }
                        this.nextValues(emitter2);
                    }
                });
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    M getValue(final Map.Entry<Object, Object> entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(entry.getKey(), entry.getValue()){

            @Override
            public V setValue(V value) {
                return MapReactiveIterator.this.map.put(entry.getKey(), value);
            }
        };
    }

    public RFuture<MapScanResult<Object, Object>> scanIterator(RedisClient client, long nextIterPos) {
        return this.map.scanIteratorAsync(this.map.getName(), client, nextIterPos, this.pattern, this.count);
    }
}

