/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.set;

import org.redisson.RedissonSet;
import org.redisson.RedissonSetCache;
import org.redisson.api.RLock;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;

public abstract class SetOperation
extends TransactionalOperation {
    private final String transactionId;

    public SetOperation(String name, Codec codec, String transactionId) {
        super(name, codec);
        this.transactionId = transactionId;
    }

    protected RLock getLock(RSetCache<?> setCache, CommandAsyncExecutor commandExecutor, Object value) {
        String lockName = ((RedissonSetCache)setCache).getLockName(value, "lock");
        return new RedissonTransactionalLock(commandExecutor, lockName, this.transactionId);
    }

    protected RLock getLock(RSet<?> setCache, CommandAsyncExecutor commandExecutor, Object value) {
        String lockName = ((RedissonSet)setCache).getLockName(value, "lock");
        return new RedissonTransactionalLock(commandExecutor, lockName, this.transactionId);
    }
}

