/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.api.RBucket;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonBucket<V>
extends RedissonExpirable
implements RBucket<V> {
    public RedissonBucket(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    public RedissonBucket(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public boolean compareAndSet(V expect, V update) {
        return this.get(this.compareAndSetAsync(expect, update));
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(V expect, V update) {
        if (expect == null && update == null) {
            return this.trySetAsync(null);
        }
        if (expect == null) {
            return this.trySetAsync(update);
        }
        if (update == null) {
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('del', KEYS[1]); return 1 else return 0 end", Collections.singletonList(this.getName()), this.encode(expect));
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1 else return 0 end", Collections.singletonList(this.getName()), this.encode(expect), this.encode(update));
    }

    @Override
    public V getAndSet(V newValue) {
        return this.get(this.getAndSetAsync(newValue));
    }

    @Override
    public RFuture<V> getAndSetAsync(V newValue) {
        if (newValue == null) {
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return v", Collections.singletonList(this.getName()), new Object[0]);
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.GETSET, this.getName(), this.encode(newValue));
    }

    @Override
    public V get() {
        return this.get(this.getAsync());
    }

    @Override
    public RFuture<V> getAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.GET, this.getName());
    }

    @Override
    public V getAndDelete() {
        return this.get(this.getAndDeleteAsync());
    }

    @Override
    public RFuture<V> getAndDeleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return currValue; ", Collections.singletonList(this.getName()), new Object[0]);
    }

    @Override
    public long size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Long> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.STRLEN, this.getName());
    }

    @Override
    public void set(V value) {
        this.get(this.setAsync(value));
    }

    @Override
    public RFuture<Void> setAsync(V value) {
        if (value == null) {
            return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_VOID, this.getName());
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SET, this.getName(), this.encode(value));
    }

    @Override
    public void set(V value, long timeToLive, TimeUnit timeUnit) {
        this.get(this.setAsync(value, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        if (value == null) {
            return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_VOID, this.getName());
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.PSETEX, this.getName(), timeUnit.toMillis(timeToLive), this.encode(value));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value) {
        if (value == null) {
            return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.NOT_EXISTS, this.getName());
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SETNX, this.getName(), this.encode(value));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null");
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SETPXNX, this.getName(), this.encode(value), "PX", timeUnit.toMillis(timeToLive), "NX");
    }

    @Override
    public boolean trySet(V value, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.trySetAsync(value, timeToLive, timeUnit));
    }

    @Override
    public boolean trySet(V value) {
        return this.get(this.trySetAsync(value));
    }
}

