/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StorageKeyFormat {
    public static final StorageKeyFormat EMPTY = new StorageKeyFormat(null, null);
    public static final String WEBAPP_VERSION = "webappVersion";
    public static final String HOST = "host";
    public static final String HOST_HASH = "host.hash";
    public static final String CONTEXT = "context";
    public static final String CONTEXT_HASH = "context.hash";
    private static final char STORAGE_TOKEN_SEP = ':';
    private static final char STORAGE_KEY_SEP = '_';
    final String prefix;
    private final String config;

    private StorageKeyFormat(String prefix, String config) {
        if ("lock:".equals(prefix) || "bak:".equals(prefix) || "validity:".equals(prefix)) {
            throw new IllegalArgumentException("The storage key prefix contains a reserved word (used for other purposes): " + prefix);
        }
        this.prefix = prefix;
        this.config = config;
    }

    public static StorageKeyFormat ofHost(String host) {
        return StorageKeyFormat.of(HOST, host, null, null);
    }

    public static StorageKeyFormat of(String config, String host, String context, String webappVersion) {
        if (config == null || config.trim().isEmpty()) {
            return EMPTY;
        }
        String[] tokens = config.split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            String value = PrefixTokenFactory.parse(tokens[i], host, context, webappVersion);
            if (value == null || value.trim().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(value);
        }
        String prefix = sb.length() == 0 ? null : sb.append('_').toString();
        return new StorageKeyFormat(prefix, config);
    }

    public String format(String input) {
        if (this.prefix == null) {
            return input;
        }
        return this.prefix + input;
    }

    static String hashString(String s) {
        return StorageKeyFormat.hashString(s, 8);
    }

    static String hashString(String s, int maxLength) {
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            hash = md.digest(s.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                sb.append(0);
                sb.append(hex.charAt(hex.length() - 1));
                continue;
            }
            sb.append(hex.substring(hex.length() - 2));
        }
        String str = sb.toString();
        return str.substring(0, Math.min(maxLength, str.length()));
    }

    public String toString() {
        return "StorageKeyFormat [prefix=" + this.prefix + ", config=" + this.config + "]";
    }

    static class PrefixTokenFactory {
        static final Pattern STATIC_PATTERN = Pattern.compile("static:([^:]+)");

        PrefixTokenFactory() {
        }

        static String parse(String configToken, String host, String context, String webappVersion) {
            Matcher staticMatcher = STATIC_PATTERN.matcher(configToken);
            if (staticMatcher.matches()) {
                return staticMatcher.group(1);
            }
            if (StorageKeyFormat.HOST.equals(configToken)) {
                return host;
            }
            if (StorageKeyFormat.HOST_HASH.equals(configToken)) {
                return StorageKeyFormat.hashString(host);
            }
            if (StorageKeyFormat.CONTEXT.equals(configToken)) {
                return context;
            }
            if (StorageKeyFormat.CONTEXT_HASH.equals(configToken)) {
                return StorageKeyFormat.hashString(context);
            }
            if (StorageKeyFormat.WEBAPP_VERSION.equals(configToken)) {
                return webappVersion;
            }
            throw new IllegalArgumentException("Unsupported config token " + configToken);
        }
    }
}

