/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonList;
import org.redisson.RedissonSubList;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.api.SortOrder;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanNumberReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonListMultimapValues<V>
extends RedissonExpirable
implements RList<V> {
    private final RList<V> list;
    private final Object key;
    private final String timeoutSetName;

    public RedissonListMultimapValues(Codec codec, CommandAsyncExecutor commandExecutor, String name, String timeoutSetName, Object key) {
        super(codec, commandExecutor, name);
        this.timeoutSetName = timeoutSetName;
        this.key = key;
        this.list = new RedissonList(codec, commandExecutor, name, null);
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return null;
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync() {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getName(), this.timeoutSetName);
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local res = redis.call('zrem', KEYS[1], ARGV[2]); if res > 0 then redis.call('del', KEYS[2]); end; return res; ", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_INTEGER, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('llen', KEYS[2]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.encodeMapKey(this.key));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public Iterator<V> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        List<V> list = this.readAll();
        return list.toArray();
    }

    @Override
    public List<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<List<V>> readAllAsync() {
        return this.rangeAsync(0, -1);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List<V> list = this.readAll();
        return list.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.list.add(e);
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        return this.list.addAsync(e);
    }

    @Override
    public RFuture<Boolean> addAsync(int index, V element) {
        return this.list.addAsync(index, element);
    }

    @Override
    public boolean remove(Object o) {
        return this.get(this.removeAsync(o));
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.removeAsync(o, 1);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o, int count) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('lrem', KEYS[2], ARGV[2], ARGV[4]) > 0 and 1 or 0;", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), count, this.encodeMapKey(this.key), this.encodeMapValue(o));
    }

    @Override
    public boolean remove(Object o, int count) {
        return this.get(this.removeAsync(o, count));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        args.add(System.currentTimeMillis());
        args.add(this.encodeMapKey(this.key));
        this.encodeMapValues(args, c);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local items = redis.call('lrange', KEYS[2], 0, -1);for i = 1, #items, 1 do for j = 2, #ARGV, 1 do if ARGV[j] == items[i] then table.remove(ARGV, j) end end; end;return #ARGV == 2 and 1 or 0; ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.list.addAll(c);
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        return this.list.addAllAsync(c);
    }

    @Override
    public RFuture<Boolean> addAllAsync(int index, Collection<? extends V> coll) {
        return this.list.addAllAsync(index, coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> coll) {
        return this.list.addAll(index, coll);
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        args.add(System.currentTimeMillis());
        args.add(this.encodeMapKey(this.key));
        this.encodeMapValues(args, c);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local v = 0 for i = 2, #ARGV, 1 do if redis.call('lrem', KEYS[2], 0, ARGV[i]) == 1 then v = 1 end end return v ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        args.add(System.currentTimeMillis());
        args.add(this.encodeMapKey(this.key));
        this.encodeMapValues(args, c);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local changed = 0; local s = redis.call('lrange', KEYS[2], 0, -1); local i = 1; while i <= #s do local element = s[i]; local isInAgrs = false; for j = 2, #ARGV, 1 do if ARGV[j] == element then isInAgrs = true; break; end; end; if isInAgrs == false then redis.call('lrem', KEYS[2], 0, element); changed = 1; end; i = i + 1; end; return changed; ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public List<V> get(int ... indexes) {
        return this.get(this.getAsync(indexes));
    }

    @Override
    public RFuture<List<V>> getAsync(int ... indexes) {
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>();
        params.add(Long.valueOf(System.currentTimeMillis()));
        params.add(this.encodeMapKey(this.key));
        int[] nArray = indexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer index = nArray[i];
            params.add(index);
        }
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_LIST, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return nil;end; local result = {}; for i = 3, #ARGV, 1 do local value = redis.call('lindex', KEYS[1], ARGV[i]);table.insert(result, value);end; return result;", Collections.singletonList(this.getName()), params.toArray());
    }

    @Override
    public RFuture<V> getAsync(int index) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return nil;end; return redis.call('lindex', KEYS[2], ARGV[2]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), index, this.encodeMapKey(this.key));
    }

    @Override
    public V get(int index) {
        return this.getValue(index);
    }

    V getValue(int index) {
        return this.get(this.getAsync(index));
    }

    @Override
    public V set(int index, V element) {
        return this.list.set(index, element);
    }

    @Override
    public RFuture<V> setAsync(int index, V element) {
        return this.list.setAsync(index, element);
    }

    @Override
    public void fastSet(int index, V element) {
        this.list.fastSet(index, element);
    }

    @Override
    public RFuture<Void> fastSetAsync(int index, V element) {
        return this.list.fastSetAsync(index, element);
    }

    @Override
    public void add(int index, V element) {
        this.addAll(index, (Collection<? extends V>)Collections.singleton(element));
    }

    @Override
    public V remove(int index) {
        return (V)this.list.remove(index);
    }

    @Override
    public RFuture<V> removeAsync(int index) {
        return this.list.removeAsync(index);
    }

    @Override
    public void fastRemove(int index) {
        this.list.fastRemove(index);
    }

    @Override
    public RFuture<Void> fastRemoveAsync(int index) {
        return this.list.fastRemoveAsync(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.get(this.indexOfAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.indexOfAsync(o, new BooleanNumberReplayConvertor(-1L));
    }

    private <R> RFuture<R> indexOfAsync(Object o, Convertor<R> convertor) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, new RedisCommand<R>("EVAL", convertor), "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return -1;end; local items = redis.call('lrange', KEYS[2], 0, -1); for i=1,#items do if items[i] == ARGV[3] then return i - 1; end; end; return -1;", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.encodeMapKey(this.key), this.encodeMapValue(o));
    }

    @Override
    public RFuture<Integer> indexOfAsync(Object o) {
        return this.indexOfAsync(o, new IntegerReplayConvertor());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.get(this.lastIndexOfAsync(o));
    }

    @Override
    public RFuture<Integer> lastIndexOfAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_INTEGER, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return -1;end; local items = redis.call('lrange', KEYS[1], 0, -1) for i = #items, 1, -1 do if items[i] == ARGV[1] then return i - 1 end end return -1", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.encodeMapKey(this.key), this.encodeMapValue(o));
    }

    @Override
    public void trim(int fromIndex, int toIndex) {
        this.list.trim(fromIndex, toIndex);
    }

    @Override
    public RFuture<Void> trimAsync(int fromIndex, int toIndex) {
        return this.list.trimAsync(fromIndex, toIndex);
    }

    @Override
    public ListIterator<V> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<V> listIterator(final int ind) {
        return new ListIterator<V>(){
            private V prevCurrentValue;
            private V nextCurrentValue;
            private V currentValueHasRead;
            private int currentIndex;
            private boolean hasBeenModified;
            {
                this.currentIndex = ind - 1;
                this.hasBeenModified = true;
            }

            @Override
            public boolean hasNext() {
                Object val = RedissonListMultimapValues.this.getValue(this.currentIndex + 1);
                if (val != null) {
                    this.nextCurrentValue = val;
                }
                return val != null;
            }

            @Override
            public V next() {
                if (this.nextCurrentValue == null && !this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                ++this.currentIndex;
                this.currentValueHasRead = this.nextCurrentValue;
                this.nextCurrentValue = null;
                this.hasBeenModified = false;
                return this.currentValueHasRead;
            }

            @Override
            public void remove() {
                if (this.currentValueHasRead == null) {
                    throw new IllegalStateException("Neither next nor previous have been called");
                }
                if (this.hasBeenModified) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonListMultimapValues.this.remove(this.currentIndex);
                --this.currentIndex;
                this.hasBeenModified = true;
                this.currentValueHasRead = null;
            }

            @Override
            public boolean hasPrevious() {
                if (this.currentIndex < 0) {
                    return false;
                }
                Object val = RedissonListMultimapValues.this.getValue(this.currentIndex);
                if (val != null) {
                    this.prevCurrentValue = val;
                }
                return val != null;
            }

            @Override
            public V previous() {
                if (this.prevCurrentValue == null && !this.hasPrevious()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                --this.currentIndex;
                this.hasBeenModified = false;
                this.currentValueHasRead = this.prevCurrentValue;
                this.prevCurrentValue = null;
                return this.currentValueHasRead;
            }

            @Override
            public int nextIndex() {
                return this.currentIndex + 1;
            }

            @Override
            public int previousIndex() {
                return this.currentIndex;
            }

            @Override
            public void set(V e) {
                if (this.hasBeenModified) {
                    throw new IllegalStateException();
                }
                RedissonListMultimapValues.this.fastSet(this.currentIndex, e);
            }

            @Override
            public void add(V e) {
                RedissonListMultimapValues.this.add(this.currentIndex + 1, e);
                ++this.currentIndex;
                this.hasBeenModified = true;
            }
        };
    }

    @Override
    public RList<V> subList(int fromIndex, int toIndex) {
        int size = this.size();
        if (fromIndex < 0 || toIndex > size) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + " size: " + size);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex: " + fromIndex + " toIndex: " + toIndex);
        }
        return new RedissonSubList(this.codec, this.commandExecutor, this.getName(), fromIndex, toIndex);
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        Iterator<V> e1 = this.iterator();
        Iterator e2 = ((List)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            V o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (V e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public RFuture<Integer> addAfterAsync(V elementToFind, V element) {
        return this.list.addAfterAsync(elementToFind, element);
    }

    @Override
    public RFuture<Integer> addBeforeAsync(V elementToFind, V element) {
        return this.list.addBeforeAsync(elementToFind, element);
    }

    @Override
    public int addAfter(V elementToFind, V element) {
        return this.list.addAfter(elementToFind, element);
    }

    @Override
    public int addBefore(V elementToFind, V element) {
        return this.list.addBefore(elementToFind, element);
    }

    @Override
    public RFuture<List<V>> readSortAsync(SortOrder order) {
        return this.list.readSortAsync(order);
    }

    @Override
    public List<V> readSort(SortOrder order) {
        return (List)this.list.readSort(order);
    }

    @Override
    public RFuture<List<V>> readSortAsync(SortOrder order, int offset, int count) {
        return this.list.readSortAsync(order, offset, count);
    }

    @Override
    public List<V> readSort(SortOrder order, int offset, int count) {
        return (List)this.list.readSort(order, offset, count);
    }

    @Override
    public List<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        return (List)this.list.readSort(byPattern, order, offset, count);
    }

    @Override
    public RFuture<List<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.list.readSortAsync(byPattern, order, offset, count);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.list.readSort(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.list.readSortAsync(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public List<V> readSortAlpha(SortOrder order) {
        return (List)this.list.readSortAlpha(order);
    }

    @Override
    public List<V> readSortAlpha(SortOrder order, int offset, int count) {
        return (List)this.list.readSortAlpha(order, offset, count);
    }

    @Override
    public List<V> readSortAlpha(String byPattern, SortOrder order) {
        return (List)this.list.readSortAlpha(byPattern, order);
    }

    @Override
    public List<V> readSortAlpha(String byPattern, SortOrder order, int offset, int count) {
        return (List)this.list.readSortAlpha(byPattern, order, offset, count);
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.list.readSortAlpha(byPattern, getPatterns, order);
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.list.readSortAlpha(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public RFuture<List<V>> readSortAlphaAsync(SortOrder order) {
        return this.list.readSortAlphaAsync(order);
    }

    @Override
    public RFuture<List<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        return this.list.readSortAlphaAsync(order, offset, count);
    }

    @Override
    public RFuture<List<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        return this.list.readSortAlphaAsync(byPattern, order);
    }

    @Override
    public RFuture<List<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.list.readSortAlphaAsync(byPattern, order, offset, count);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.list.readSortAlphaAsync(byPattern, getPatterns, order);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.list.readSortAlphaAsync(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public int sortTo(String destName, SortOrder order) {
        return this.list.sortTo(destName, order);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        return this.list.sortToAsync(destName, order);
    }

    @Override
    public List<V> readSort(String byPattern, SortOrder order) {
        return (List)this.list.readSort(byPattern, order);
    }

    @Override
    public RFuture<List<V>> readSortAsync(String byPattern, SortOrder order) {
        return this.list.readSortAsync(byPattern, order);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.list.readSort(byPattern, getPatterns, order);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.list.readSortAsync(byPattern, getPatterns, order);
    }

    @Override
    public int sortTo(String destName, SortOrder order, int offset, int count) {
        return this.list.sortTo(destName, order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order) {
        return this.list.sortTo(destName, byPattern, order);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        return this.list.sortToAsync(destName, order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.list.sortTo(destName, byPattern, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        return this.list.sortToAsync(destName, byPattern, order);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.list.sortTo(destName, byPattern, getPatterns, order);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.list.sortToAsync(destName, byPattern, order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.list.sortTo(destName, byPattern, getPatterns, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.list.sortToAsync(destName, byPattern, getPatterns, order);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.list.sortToAsync(destName, byPattern, getPatterns, order, offset, count);
    }

    @Override
    public RFuture<List<V>> rangeAsync(int toIndex) {
        return this.rangeAsync(0, toIndex);
    }

    @Override
    public RFuture<List<V>> rangeAsync(int fromIndex, int toIndex) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE_LIST, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return {};end; return redis.call('lrange', KEYS[2], ARGV[3], ARGV[4]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.encodeMapKey(this.key), fromIndex, toIndex);
    }

    @Override
    public List<V> range(int toIndex) {
        return this.get(this.rangeAsync(toIndex));
    }

    @Override
    public List<V> range(int fromIndex, int toIndex) {
        return this.get(this.rangeAsync(fromIndex, toIndex));
    }
}

