/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.session.StandardSession;
import org.redisson.api.RMap;
import org.redisson.api.RSet;
import org.redisson.api.RTopic;
import org.redisson.tomcat.AttributeRemoveMessage;
import org.redisson.tomcat.AttributeUpdateMessage;
import org.redisson.tomcat.AttributesClearMessage;
import org.redisson.tomcat.AttributesPutAllMessage;
import org.redisson.tomcat.RedissonSessionManager;

public class RedissonSession
extends StandardSession {
    private static final String IS_NEW_ATTR = "session:isNew";
    private static final String IS_VALID_ATTR = "session:isValid";
    private static final String THIS_ACCESSED_TIME_ATTR = "session:thisAccessedTime";
    private static final String MAX_INACTIVE_INTERVAL_ATTR = "session:maxInactiveInterval";
    private static final String LAST_ACCESSED_TIME_ATTR = "session:lastAccessedTime";
    private static final String CREATION_TIME_ATTR = "session:creationTime";
    private static final String IS_EXPIRATION_LOCKED = "session:isExpirationLocked";
    public static final Set<String> ATTRS = new HashSet<String>(Arrays.asList("session:isNew", "session:isValid", "session:thisAccessedTime", "session:maxInactiveInterval", "session:lastAccessedTime", "session:creationTime", "session:isExpirationLocked"));
    private boolean isExpirationLocked;
    private boolean loaded;
    private final RedissonSessionManager redissonManager;
    private final Map<String, Object> attrs;
    private RMap<String, Object> map;
    private final RTopic topic;
    private final RedissonSessionManager.ReadMode readMode;
    private final RedissonSessionManager.UpdateMode updateMode;
    private Set<String> removedAttributes = Collections.emptySet();
    private final boolean broadcastSessionEvents;
    private static final long serialVersionUID = -2518607181636076487L;

    public RedissonSession(RedissonSessionManager manager, RedissonSessionManager.ReadMode readMode, RedissonSessionManager.UpdateMode updateMode, boolean broadcastSessionEvents) {
        super(manager);
        this.redissonManager = manager;
        this.readMode = readMode;
        this.updateMode = updateMode;
        this.topic = this.redissonManager.getTopic();
        this.broadcastSessionEvents = broadcastSessionEvents;
        if (updateMode == RedissonSessionManager.UpdateMode.AFTER_REQUEST) {
            this.removedAttributes = Collections.newSetFromMap(new ConcurrentHashMap());
        }
        try {
            Field attr = StandardSession.class.getDeclaredField("attributes");
            this.attrs = (Map)attr.get(this);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) {
        if (this.readMode == RedissonSessionManager.ReadMode.REDIS) {
            if (!this.isValidInternal()) {
                throw new IllegalStateException(sm.getString("standardSession.getAttribute.ise"));
            }
            if (name == null) {
                return null;
            }
            return this.map.get(name);
        }
        if (!this.loaded) {
            RedissonSession redissonSession = this;
            synchronized (redissonSession) {
                if (!this.loaded) {
                    Map<String, Object> storedAttrs = this.map.readAllMap();
                    this.load(storedAttrs);
                    this.loaded = true;
                }
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.readMode == RedissonSessionManager.ReadMode.REDIS) {
            if (!this.isValidInternal()) {
                throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
            }
            return Collections.enumeration(this.map.readAllKeySet());
        }
        return super.getAttributeNames();
    }

    @Override
    public String[] getValueNames() {
        if (this.readMode == RedissonSessionManager.ReadMode.REDIS) {
            if (!this.isValidInternal()) {
                throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
            }
            Set<String> keys = this.map.readAllKeySet();
            return keys.toArray(new String[keys.size()]);
        }
        return super.getValueNames();
    }

    public void delete() {
        if (this.map == null) {
            this.map = this.redissonManager.getMap(this.id);
        }
        if (this.broadcastSessionEvents) {
            RSet<String> set = this.redissonManager.getNotifiedNodes(this.id);
            set.add(this.redissonManager.getNodeId());
            set.expire(60L, TimeUnit.SECONDS);
            this.map.fastPut(IS_EXPIRATION_LOCKED, true);
            this.map.expire(60L, TimeUnit.SECONDS);
        } else {
            this.map.delete();
        }
        if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
            this.topic.publish(new AttributesClearMessage(this.redissonManager.getNodeId(), this.getId()));
        }
        this.map = null;
    }

    @Override
    public void setCreationTime(long time) {
        super.setCreationTime(time);
        if (this.map != null) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(3);
            newMap.put(CREATION_TIME_ATTR, this.creationTime);
            newMap.put(LAST_ACCESSED_TIME_ATTR, this.lastAccessedTime);
            newMap.put(THIS_ACCESSED_TIME_ATTR, this.thisAccessedTime);
            this.map.putAll(newMap);
            if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
                this.topic.publish(this.createPutAllMessage(newMap));
            }
        }
    }

    @Override
    public void access() {
        super.access();
        if (this.map != null) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(2);
            newMap.put(LAST_ACCESSED_TIME_ATTR, this.lastAccessedTime);
            newMap.put(THIS_ACCESSED_TIME_ATTR, this.thisAccessedTime);
            this.map.putAll(newMap);
            if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
                this.topic.publish(this.createPutAllMessage(newMap));
            }
            this.expireSession();
        }
    }

    protected void expireSession() {
        if (this.isExpirationLocked) {
            return;
        }
        if (this.maxInactiveInterval >= 0) {
            this.map.expire(this.maxInactiveInterval + 60, TimeUnit.SECONDS);
        }
    }

    protected AttributesPutAllMessage createPutAllMessage(Map<String, Object> newMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        try {
            return new AttributesPutAllMessage(this.redissonManager.getNodeId(), this.getId(), map, this.map.getCodec().getMapValueEncoder());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        super.setMaxInactiveInterval(interval);
        if (this.map != null) {
            this.fastPut(MAX_INACTIVE_INTERVAL_ATTR, this.maxInactiveInterval);
            this.expireSession();
        }
    }

    private void fastPut(String name, Object value) {
        this.map.fastPut(name, value);
        if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
            try {
                this.topic.publish(new AttributeUpdateMessage(this.redissonManager.getNodeId(), this.getId(), name, value, this.map.getCodec().getMapValueEncoder()));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void setValid(boolean isValid) {
        super.setValid(isValid);
        if (this.map != null) {
            if (!isValid && !this.map.isExists()) {
                return;
            }
            this.fastPut(IS_VALID_ATTR, isValid);
        }
    }

    @Override
    public void setNew(boolean isNew) {
        super.setNew(isNew);
        if (this.map != null) {
            this.fastPut(IS_NEW_ATTR, isNew);
        }
    }

    @Override
    public void endAccess() {
        boolean oldValue = this.isNew;
        super.endAccess();
        if (this.isNew != oldValue && this.map != null) {
            this.fastPut(IS_NEW_ATTR, this.isNew);
        }
    }

    public void superSetAttribute(String name, Object value, boolean notify) {
        super.setAttribute(name, value, notify);
    }

    @Override
    public void setAttribute(String name, Object value, boolean notify) {
        super.setAttribute(name, value, notify);
        if (value == null) {
            return;
        }
        if (this.updateMode == RedissonSessionManager.UpdateMode.DEFAULT && this.map != null) {
            this.fastPut(name, value);
        }
        if (this.updateMode == RedissonSessionManager.UpdateMode.AFTER_REQUEST) {
            this.removedAttributes.remove(name);
        }
    }

    public void superRemoveAttributeInternal(String name, boolean notify) {
        super.removeAttributeInternal(name, notify);
    }

    @Override
    protected void removeAttributeInternal(String name, boolean notify) {
        super.removeAttributeInternal(name, notify);
        if (this.updateMode == RedissonSessionManager.UpdateMode.DEFAULT && this.map != null) {
            this.map.fastRemove((String[])new String[]{name});
            if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
                this.topic.publish(new AttributeRemoveMessage(this.redissonManager.getNodeId(), this.getId(), new HashSet<String>(Arrays.asList(name))));
            }
        }
        if (this.updateMode == RedissonSessionManager.UpdateMode.AFTER_REQUEST) {
            this.removedAttributes.add(name);
        }
    }

    public void save() {
        if (this.map == null) {
            this.map = this.redissonManager.getMap(this.id);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put(CREATION_TIME_ATTR, this.creationTime);
        newMap.put(LAST_ACCESSED_TIME_ATTR, this.lastAccessedTime);
        newMap.put(THIS_ACCESSED_TIME_ATTR, this.thisAccessedTime);
        newMap.put(MAX_INACTIVE_INTERVAL_ATTR, this.maxInactiveInterval);
        newMap.put(IS_VALID_ATTR, this.isValid);
        newMap.put(IS_NEW_ATTR, this.isNew);
        if (this.broadcastSessionEvents) {
            newMap.put(IS_EXPIRATION_LOCKED, this.isExpirationLocked);
        }
        if (this.attrs != null) {
            for (Map.Entry<String, Object> entry : this.attrs.entrySet()) {
                newMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.map.putAll(newMap);
        this.map.fastRemove((String[])this.removedAttributes.toArray(new String[this.removedAttributes.size()]));
        if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
            this.topic.publish(this.createPutAllMessage(newMap));
            if (this.updateMode == RedissonSessionManager.UpdateMode.AFTER_REQUEST && !this.removedAttributes.isEmpty()) {
                this.topic.publish(new AttributeRemoveMessage(this.redissonManager.getNodeId(), this.getId(), this.removedAttributes));
            }
        }
        this.removedAttributes.clear();
        this.expireSession();
    }

    public void load(Map<String, Object> attrs) {
        Boolean isExpirationLocked;
        Boolean isNew;
        Boolean isValid;
        Long thisAccessedTime;
        Integer maxInactiveInterval;
        Long lastAccessedTime;
        Long creationTime = (Long)attrs.remove(CREATION_TIME_ATTR);
        if (creationTime != null) {
            this.creationTime = creationTime;
        }
        if ((lastAccessedTime = (Long)attrs.remove(LAST_ACCESSED_TIME_ATTR)) != null) {
            this.lastAccessedTime = lastAccessedTime;
        }
        if ((maxInactiveInterval = (Integer)attrs.remove(MAX_INACTIVE_INTERVAL_ATTR)) != null) {
            this.maxInactiveInterval = maxInactiveInterval;
        }
        if ((thisAccessedTime = (Long)attrs.remove(THIS_ACCESSED_TIME_ATTR)) != null) {
            this.thisAccessedTime = thisAccessedTime;
        }
        if ((isValid = (Boolean)attrs.remove(IS_VALID_ATTR)) != null) {
            this.isValid = isValid;
        }
        if ((isNew = (Boolean)attrs.remove(IS_NEW_ATTR)) != null) {
            this.isNew = isNew;
        }
        if ((isExpirationLocked = (Boolean)attrs.remove(IS_EXPIRATION_LOCKED)) != null) {
            this.isExpirationLocked = isExpirationLocked;
        }
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            super.setAttribute(entry.getKey(), entry.getValue(), false);
        }
    }

    @Override
    public void recycle() {
        super.recycle();
        this.map = null;
    }
}

