/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.manager.StatusTransformer;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class StatusManagerServlet
extends HttpServlet
implements NotificationListener {
    private static final long serialVersionUID = 1L;
    protected MBeanServer mBeanServer = null;
    protected final Vector<ObjectName> protocolHandlers = new Vector();
    protected final Vector<ObjectName> threadPools = new Vector();
    protected final Vector<ObjectName> requestProcessors = new Vector();
    protected final Vector<ObjectName> globalRequestProcessors = new Vector();
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.manager");

    @Override
    public void init() throws ServletException {
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        try {
            String onStr = "*:type=ProtocolHandler,*";
            ObjectName objectName = new ObjectName(onStr);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.protocolHandlers.addElement(oi.getObjectName());
            }
            onStr = "*:type=ThreadPool,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.threadPools.addElement(oi.getObjectName());
            }
            onStr = "*:type=GlobalRequestProcessor,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.globalRequestProcessors.addElement(oi.getObjectName());
            }
            onStr = "*:type=RequestProcessor,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.requestProcessors.addElement(oi.getObjectName());
            }
            onStr = "JMImplementation:type=MBeanServerDelegate";
            objectName = new ObjectName(onStr);
            this.mBeanServer.addNotificationListener(objectName, this, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        String onStr = "JMImplementation:type=MBeanServerDelegate";
        try {
            ObjectName objectName = new ObjectName(onStr);
            this.mBeanServer.removeNotificationListener(objectName, this, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int mode = 0;
        if (request.getParameter("XML") != null && request.getParameter("XML").equals("true")) {
            mode = 1;
        }
        StatusTransformer.setContentType(response, mode);
        PrintWriter writer = response.getWriter();
        boolean completeStatus = false;
        if (request.getPathInfo() != null && request.getPathInfo().equals("/all")) {
            completeStatus = true;
        }
        Object[] args = new Object[]{request.getContextPath()};
        StatusTransformer.writeHeader(writer, args, mode);
        args = new Object[]{request.getContextPath(), completeStatus ? sm.getString("statusServlet.complete") : sm.getString("statusServlet.title")};
        StatusTransformer.writeBody(writer, args, mode);
        args = new Object[9];
        args[0] = sm.getString("htmlManagerServlet.manager");
        args[1] = response.encodeURL(request.getContextPath() + "/html/list");
        args[2] = sm.getString("htmlManagerServlet.list");
        args[3] = response.encodeURL(request.getContextPath() + "/" + sm.getString("htmlManagerServlet.helpHtmlManagerFile"));
        args[4] = sm.getString("htmlManagerServlet.helpHtmlManager");
        args[5] = response.encodeURL(request.getContextPath() + "/" + sm.getString("htmlManagerServlet.helpManagerFile"));
        args[6] = sm.getString("htmlManagerServlet.helpManager");
        if (completeStatus) {
            args[7] = response.encodeURL(request.getContextPath() + "/status");
            args[8] = sm.getString("statusServlet.title");
        } else {
            args[7] = response.encodeURL(request.getContextPath() + "/status/all");
            args[8] = sm.getString("statusServlet.complete");
        }
        StatusTransformer.writeManager(writer, args, mode);
        args = new Object[]{sm.getString("htmlManagerServlet.serverTitle"), sm.getString("htmlManagerServlet.serverVersion"), sm.getString("htmlManagerServlet.serverJVMVersion"), sm.getString("htmlManagerServlet.serverJVMVendor"), sm.getString("htmlManagerServlet.serverOSName"), sm.getString("htmlManagerServlet.serverOSVersion"), sm.getString("htmlManagerServlet.serverOSArch"), sm.getString("htmlManagerServlet.serverHostname"), sm.getString("htmlManagerServlet.serverIPAddress")};
        StatusTransformer.writePageHeading(writer, args, mode);
        args = new Object[8];
        args[0] = ServerInfo.getServerInfo();
        args[1] = System.getProperty("java.runtime.version");
        args[2] = System.getProperty("java.vm.vendor");
        args[3] = System.getProperty("os.name");
        args[4] = System.getProperty("os.version");
        args[5] = System.getProperty("os.arch");
        try {
            InetAddress address = InetAddress.getLocalHost();
            args[6] = address.getHostName();
            args[7] = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            args[6] = "-";
            args[7] = "-";
        }
        StatusTransformer.writeServerInfo(writer, args, mode);
        try {
            StatusTransformer.writeOSState(writer, mode);
            StatusTransformer.writeVMState(writer, mode);
            Enumeration<ObjectName> enumeration = this.threadPools.elements();
            while (enumeration.hasMoreElements()) {
                ObjectName objectName = enumeration.nextElement();
                String name = objectName.getKeyProperty("name");
                StatusTransformer.writeConnectorState(writer, objectName, name, this.mBeanServer, this.globalRequestProcessors, this.requestProcessors, mode);
            }
            if (request.getPathInfo() != null && request.getPathInfo().equals("/all")) {
                StatusTransformer.writeDetailedState(writer, this.mBeanServer, mode);
            }
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
        StatusTransformer.writeFooter(writer, mode);
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            String type;
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (notification.getType().equals("JMX.mbean.registered")) {
                String type2 = objectName.getKeyProperty("type");
                if (type2 != null) {
                    if (type2.equals("ProtocolHandler")) {
                        this.protocolHandlers.addElement(objectName);
                    } else if (type2.equals("ThreadPool")) {
                        this.threadPools.addElement(objectName);
                    } else if (type2.equals("GlobalRequestProcessor")) {
                        this.globalRequestProcessors.addElement(objectName);
                    } else if (type2.equals("RequestProcessor")) {
                        this.requestProcessors.addElement(objectName);
                    }
                }
            } else if (notification.getType().equals("JMX.mbean.unregistered") && (type = objectName.getKeyProperty("type")) != null) {
                if (type.equals("ProtocolHandler")) {
                    this.protocolHandlers.removeElement(objectName);
                } else if (type.equals("ThreadPool")) {
                    this.threadPools.removeElement(objectName);
                } else if (type.equals("GlobalRequestProcessor")) {
                    this.globalRequestProcessors.removeElement(objectName);
                } else if (type.equals("RequestProcessor")) {
                    this.requestProcessors.removeElement(objectName);
                }
            }
        }
    }
}

