/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.cluster.ClusterConnectionManager;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SubscriptionMode;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.CountableListener;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.connection.balancer.LoadBalancerManager;
import org.redisson.connection.pool.MasterConnectionPool;
import org.redisson.connection.pool.MasterPubSubConnectionPool;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.TransferListener;
import org.redisson.misc.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveEntry {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    LoadBalancerManager slaveBalancer;
    ClientConnectionsEntry masterEntry;
    final MasterSlaveServersConfig config;
    final ConnectionManager connectionManager;
    final MasterConnectionPool writeConnectionPool;
    final Set<Integer> slots = new HashSet<Integer>();
    final MasterPubSubConnectionPool pubSubConnectionPool;
    final AtomicBoolean active = new AtomicBoolean(true);
    String sslHostname;

    public MasterSlaveEntry(Set<ClusterSlotRange> slotRanges, ConnectionManager connectionManager, MasterSlaveServersConfig config) {
        for (ClusterSlotRange clusterSlotRange : slotRanges) {
            for (int i = clusterSlotRange.getStartSlot(); i < clusterSlotRange.getEndSlot() + 1; ++i) {
                this.slots.add(i);
            }
        }
        this.connectionManager = connectionManager;
        this.config = config;
        this.slaveBalancer = new LoadBalancerManager(config, connectionManager, this);
        this.writeConnectionPool = new MasterConnectionPool(config, connectionManager, this);
        this.pubSubConnectionPool = new MasterPubSubConnectionPool(config, connectionManager, this);
        if (connectionManager instanceof ClusterConnectionManager) {
            this.sslHostname = ((ClusterConnectionManager)connectionManager).getConfigEndpointHostName();
        }
    }

    public MasterSlaveServersConfig getConfig() {
        return this.config;
    }

    public List<RFuture<Void>> initSlaveBalancer(Collection<URI> disconnectedNodes) {
        boolean freezeMasterAsSlave = !this.config.getSlaveAddresses().isEmpty() && !this.config.checkSkipSlavesInit() && disconnectedNodes.size() < this.config.getSlaveAddresses().size();
        LinkedList<RFuture<Void>> result = new LinkedList<RFuture<Void>>();
        RFuture<Void> f = this.addSlave(this.config.getMasterAddress(), freezeMasterAsSlave, NodeType.MASTER);
        result.add(f);
        for (URI address : this.config.getSlaveAddresses()) {
            f = this.addSlave(address, disconnectedNodes.contains(address), NodeType.SLAVE);
            result.add(f);
        }
        return result;
    }

    public RFuture<RedisClient> setupMasterEntry(InetSocketAddress address, URI uri) {
        RedisClient client = this.connectionManager.createClient(NodeType.MASTER, address, uri, this.sslHostname);
        return this.setupMasterEntry(client);
    }

    public RFuture<RedisClient> setupMasterEntry(URI address) {
        RedisClient client = this.connectionManager.createClient(NodeType.MASTER, address, this.sslHostname);
        return this.setupMasterEntry(client);
    }

    private RFuture<RedisClient> setupMasterEntry(final RedisClient client) {
        final RedissonPromise<RedisClient> result = new RedissonPromise<RedisClient>();
        RFuture<InetSocketAddress> addrFuture = client.resolveAddr();
        addrFuture.addListener(new FutureListener<InetSocketAddress>(){

            @Override
            public void operationComplete(Future<InetSocketAddress> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                MasterSlaveEntry.this.masterEntry = new ClientConnectionsEntry(client, MasterSlaveEntry.this.config.getMasterConnectionMinimumIdleSize(), MasterSlaveEntry.this.config.getMasterConnectionPoolSize(), MasterSlaveEntry.this.config.getSubscriptionConnectionMinimumIdleSize(), MasterSlaveEntry.this.config.getSubscriptionConnectionPoolSize(), MasterSlaveEntry.this.connectionManager, NodeType.MASTER);
                CountableListener<RedisClient> listener = new CountableListener<RedisClient>(result, client);
                RFuture writeFuture = MasterSlaveEntry.this.writeConnectionPool.add(MasterSlaveEntry.this.masterEntry);
                listener.incCounter();
                writeFuture.addListener(listener);
                if (MasterSlaveEntry.this.config.getSubscriptionMode() == SubscriptionMode.MASTER) {
                    RFuture pubSubFuture = MasterSlaveEntry.this.pubSubConnectionPool.add(MasterSlaveEntry.this.masterEntry);
                    listener.incCounter();
                    pubSubFuture.addListener(listener);
                }
            }
        });
        return result;
    }

    public boolean slaveDown(ClientConnectionsEntry entry, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry e = this.slaveBalancer.freeze(entry, freezeReason);
        if (e == null) {
            return false;
        }
        return this.slaveDown(entry);
    }

    public boolean slaveDown(InetSocketAddress address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.slaveBalancer.freeze(address, freezeReason);
        if (entry == null) {
            return false;
        }
        return this.slaveDown(entry);
    }

    public boolean slaveDown(URI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.slaveBalancer.freeze(address, freezeReason);
        if (entry == null) {
            return false;
        }
        return this.slaveDown(entry);
    }

    private boolean slaveDown(ClientConnectionsEntry entry) {
        if (!this.config.checkSkipSlavesInit() && this.slaveBalancer.getAvailableClients() == 0 && this.slaveBalancer.unfreeze(this.masterEntry.getClient().getAddr(), ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} used as slave", (Object)this.masterEntry.getClient().getAddr());
        }
        entry.reset();
        this.closeConnections(entry);
        for (RedisPubSubConnection connection : entry.getAllSubscribeConnections()) {
            this.connectionManager.getSubscribeService().reattachPubSub(connection);
        }
        entry.getAllSubscribeConnections().clear();
        return true;
    }

    private void closeConnections(ClientConnectionsEntry entry) {
        RedisConnection connection;
        while ((connection = entry.pollConnection()) != null) {
            connection.closeAsync().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    MasterSlaveEntry.this.reattachBlockingQueue(connection);
                }
            });
        }
        while ((connection = entry.pollSubscribeConnection()) != null) {
            connection.closeAsync();
        }
    }

    private void reattachBlockingQueue(RedisConnection connection) {
        final CommandData commandData = connection.getCurrentCommand();
        if (commandData == null || !commandData.isBlockingCommand() || commandData.getPromise().isDone()) {
            return;
        }
        RFuture<RedisConnection> newConnection = this.connectionReadOp(RedisCommands.BLPOP_VALUE);
        newConnection.addListener(new FutureListener<RedisConnection>(){

            @Override
            public void operationComplete(Future<RedisConnection> future) throws Exception {
                if (!future.isSuccess()) {
                    MasterSlaveEntry.this.log.error("Can't resubscribe blocking queue {}", (Object)commandData);
                    return;
                }
                final RedisConnection newConnection = future.getNow();
                final FutureListener<Object> listener = new FutureListener<Object>(){

                    @Override
                    public void operationComplete(Future<Object> future) throws Exception {
                        MasterSlaveEntry.this.releaseRead(newConnection);
                    }
                };
                commandData.getPromise().addListener(listener);
                if (commandData.getPromise().isDone()) {
                    return;
                }
                ChannelFuture channelFuture = newConnection.send(commandData);
                channelFuture.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            listener.operationComplete(null);
                            commandData.getPromise().removeListener(listener);
                            MasterSlaveEntry.this.releaseRead(newConnection);
                            MasterSlaveEntry.this.log.error("Can't resubscribe blocking queue {}", (Object)commandData);
                        }
                    }
                });
            }
        });
    }

    public boolean hasSlave(RedisClient redisClient) {
        return this.slaveBalancer.contains(redisClient);
    }

    public boolean hasSlave(InetSocketAddress addr) {
        return this.slaveBalancer.contains(addr);
    }

    public boolean hasSlave(URI addr) {
        return this.slaveBalancer.contains(addr);
    }

    public int getAvailableClients() {
        return this.slaveBalancer.getAvailableClients();
    }

    public RFuture<Void> addSlave(URI address) {
        return this.addSlave(address, false, NodeType.SLAVE);
    }

    public RFuture<Void> addSlave(InetSocketAddress address, URI uri) {
        return this.addSlave(address, uri, false, NodeType.SLAVE);
    }

    private RFuture<Void> addSlave(final RedisClient client, final boolean freezed, final NodeType nodeType) {
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<InetSocketAddress> addrFuture = client.resolveAddr();
        addrFuture.addListener(new FutureListener<InetSocketAddress>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<InetSocketAddress> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                ClientConnectionsEntry entry = new ClientConnectionsEntry(client, MasterSlaveEntry.this.config.getSlaveConnectionMinimumIdleSize(), MasterSlaveEntry.this.config.getSlaveConnectionPoolSize(), MasterSlaveEntry.this.config.getSubscriptionConnectionMinimumIdleSize(), MasterSlaveEntry.this.config.getSubscriptionConnectionPoolSize(), MasterSlaveEntry.this.connectionManager, nodeType);
                if (freezed) {
                    ClientConnectionsEntry clientConnectionsEntry = entry;
                    synchronized (clientConnectionsEntry) {
                        entry.setFreezed(freezed);
                        entry.setFreezeReason(ClientConnectionsEntry.FreezeReason.SYSTEM);
                    }
                }
                RFuture<Void> addFuture = MasterSlaveEntry.this.slaveBalancer.add(entry);
                addFuture.addListener(new TransferListener(result));
            }
        });
        return result;
    }

    private RFuture<Void> addSlave(InetSocketAddress address, URI uri, boolean freezed, NodeType nodeType) {
        RedisClient client = this.connectionManager.createClient(NodeType.SLAVE, address, uri, this.sslHostname);
        return this.addSlave(client, freezed, nodeType);
    }

    private RFuture<Void> addSlave(URI address, boolean freezed, NodeType nodeType) {
        RedisClient client = this.connectionManager.createClient(NodeType.SLAVE, address, this.sslHostname);
        return this.addSlave(client, freezed, nodeType);
    }

    public Collection<ClientConnectionsEntry> getSlaveEntries() {
        ArrayList<ClientConnectionsEntry> result = new ArrayList<ClientConnectionsEntry>();
        for (ClientConnectionsEntry slaveEntry : this.slaveBalancer.getEntries()) {
            if (slaveEntry.getNodeType() != NodeType.SLAVE) continue;
            result.add(slaveEntry);
        }
        return result;
    }

    public RedisClient getClient() {
        return this.masterEntry.getClient();
    }

    public boolean slaveUp(ClientConnectionsEntry entry, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (!this.slaveBalancer.unfreeze(entry, freezeReason)) {
            return false;
        }
        InetSocketAddress addr = this.masterEntry.getClient().getAddr();
        if (!this.config.checkSkipSlavesInit() && !addr.equals(entry.getClient().getAddr()) && this.slaveDown(addr, ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} excluded from slaves", (Object)addr);
        }
        return true;
    }

    public boolean isSlaveUnfreezed(URI address) {
        return this.slaveBalancer.isUnfreezed(address);
    }

    public boolean slaveUp(URI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (!this.slaveBalancer.unfreeze(address, freezeReason)) {
            return false;
        }
        InetSocketAddress addr = this.masterEntry.getClient().getAddr();
        if (!this.config.checkSkipSlavesInit() && !URIBuilder.compare(addr, address) && this.slaveDown(addr, ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} excluded from slaves", (Object)addr);
        }
        return true;
    }

    public boolean slaveUp(InetSocketAddress address, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (!this.slaveBalancer.unfreeze(address, freezeReason)) {
            return false;
        }
        InetSocketAddress addr = this.masterEntry.getClient().getAddr();
        if (!this.config.checkSkipSlavesInit() && !addr.equals(address) && this.slaveDown(addr, ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} excluded from slaves", (Object)addr);
        }
        return true;
    }

    public RFuture<RedisClient> changeMaster(URI address) {
        ClientConnectionsEntry oldMaster = this.masterEntry;
        RFuture<RedisClient> future = this.setupMasterEntry(address);
        this.changeMaster(address, oldMaster, future);
        return future;
    }

    public void changeMaster(InetSocketAddress address, URI uri) {
        ClientConnectionsEntry oldMaster = this.masterEntry;
        RFuture<RedisClient> future = this.setupMasterEntry(address, uri);
        this.changeMaster(uri, oldMaster, future);
    }

    private void changeMaster(final URI address, final ClientConnectionsEntry oldMaster, RFuture<RedisClient> future) {
        future.addListener(new FutureListener<RedisClient>(){

            @Override
            public void operationComplete(Future<RedisClient> future) throws Exception {
                if (!future.isSuccess()) {
                    MasterSlaveEntry.this.log.error("Can't change master to: {}", (Object)address);
                    return;
                }
                RedisClient newMasterClient = future.getNow();
                MasterSlaveEntry.this.writeConnectionPool.remove(oldMaster);
                MasterSlaveEntry.this.pubSubConnectionPool.remove(oldMaster);
                oldMaster.freezeMaster(ClientConnectionsEntry.FreezeReason.MANAGER);
                MasterSlaveEntry.this.slaveDown(oldMaster);
                MasterSlaveEntry.this.slaveBalancer.changeType(oldMaster.getClient(), NodeType.SLAVE);
                MasterSlaveEntry.this.slaveBalancer.changeType(newMasterClient, NodeType.MASTER);
                if (!MasterSlaveEntry.this.config.checkSkipSlavesInit() && MasterSlaveEntry.this.slaveBalancer.getAvailableClients() > 1) {
                    MasterSlaveEntry.this.slaveDown(newMasterClient.getAddr(), ClientConnectionsEntry.FreezeReason.SYSTEM);
                }
                MasterSlaveEntry.this.connectionManager.shutdownAsync(oldMaster.getClient());
                MasterSlaveEntry.this.log.info("master {} has changed to {}", (Object)oldMaster.getClient().getAddr(), (Object)MasterSlaveEntry.this.masterEntry.getClient().getAddr());
            }
        });
    }

    public boolean isFreezed() {
        return this.masterEntry.isFreezed();
    }

    public ClientConnectionsEntry.FreezeReason getFreezeReason() {
        return this.masterEntry.getFreezeReason();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreeze() {
        this.masterEntry.resetFirstFail();
        ClientConnectionsEntry clientConnectionsEntry = this.masterEntry;
        synchronized (clientConnectionsEntry) {
            this.masterEntry.setFreezed(false);
            this.masterEntry.setFreezeReason(null);
        }
    }

    public void shutdownMasterAsync() {
        if (!this.active.compareAndSet(true, false)) {
            return;
        }
        this.connectionManager.shutdownAsync(this.masterEntry.getClient());
        this.slaveBalancer.shutdownAsync();
    }

    public RFuture<RedisConnection> connectionWriteOp(RedisCommand<?> command) {
        return this.writeConnectionPool.get(command);
    }

    public RFuture<RedisConnection> connectionReadOp(RedisCommand<?> command) {
        if (this.config.getReadMode() == ReadMode.MASTER) {
            return this.connectionWriteOp(command);
        }
        return this.slaveBalancer.nextConnection(command);
    }

    public RFuture<RedisConnection> connectionReadOp(RedisCommand<?> command, URI addr) {
        if (this.config.getReadMode() == ReadMode.MASTER) {
            return this.connectionWriteOp(command);
        }
        return this.slaveBalancer.getConnection(command, addr);
    }

    public RFuture<RedisPubSubConnection> nextPubSubConnection() {
        if (this.config.getSubscriptionMode() == SubscriptionMode.MASTER) {
            return this.pubSubConnectionPool.get();
        }
        return this.slaveBalancer.nextPubSubConnection();
    }

    public void returnPubSubConnection(PubSubConnectionEntry entry) {
        if (this.config.getSubscriptionMode() == SubscriptionMode.MASTER) {
            this.pubSubConnectionPool.returnConnection(this.masterEntry, entry.getConnection());
            return;
        }
        this.slaveBalancer.returnPubSubConnection(entry.getConnection());
    }

    public void releaseWrite(RedisConnection connection) {
        this.writeConnectionPool.returnConnection(this.masterEntry, connection);
    }

    public void releaseRead(RedisConnection connection) {
        if (this.config.getReadMode() == ReadMode.MASTER) {
            this.releaseWrite(connection);
            return;
        }
        this.slaveBalancer.returnConnection(connection);
    }

    public void shutdown() {
        if (!this.active.compareAndSet(true, false)) {
            return;
        }
        this.masterEntry.getClient().shutdown();
        this.slaveBalancer.shutdown();
    }

    public void addSlotRange(Integer range) {
        this.slots.add(range);
    }

    public void removeSlotRange(Integer range) {
        this.slots.remove(range);
    }

    public Set<Integer> getSlotRanges() {
        return this.slots;
    }
}

