/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.res.StringManager;

public class Acceptor<U>
implements Runnable {
    private static final Log log = LogFactory.getLog(Acceptor.class);
    private static final StringManager sm = StringManager.getManager(Acceptor.class);
    private static final int INITIAL_ERROR_DELAY = 50;
    private static final int MAX_ERROR_DELAY = 1600;
    private final AbstractEndpoint<?, U> endpoint;
    private String threadName;
    protected volatile AcceptorState state = AcceptorState.NEW;

    public Acceptor(AbstractEndpoint<?, U> endpoint) {
        this.endpoint = endpoint;
    }

    public final AcceptorState getState() {
        return this.state;
    }

    final void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    final String getThreadName() {
        return this.threadName;
    }

    @Override
    public void run() {
        int errorDelay = 0;
        while (this.endpoint.isRunning()) {
            while (this.endpoint.isPaused() && this.endpoint.isRunning()) {
                this.state = AcceptorState.PAUSED;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.endpoint.isRunning()) break;
            this.state = AcceptorState.RUNNING;
            try {
                this.endpoint.countUpOrAwaitConnection();
                if (this.endpoint.isPaused()) continue;
                Object socket = null;
                try {
                    socket = this.endpoint.serverSocketAccept();
                }
                catch (Exception ioe) {
                    this.endpoint.countDownConnection();
                    if (!this.endpoint.isRunning()) break;
                    errorDelay = this.handleExceptionWithDelay(errorDelay);
                    throw ioe;
                }
                errorDelay = 0;
                if (this.endpoint.isRunning() && !this.endpoint.isPaused()) {
                    if (this.endpoint.setSocketOptions(socket)) continue;
                    this.endpoint.closeSocket(socket);
                    continue;
                }
                this.endpoint.destroySocket(socket);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                String msg = sm.getString("endpoint.accept.fail");
                if (t instanceof Error) {
                    Error e = (Error)t;
                    if (e.getError() == 233) {
                        log.warn(msg, t);
                        continue;
                    }
                    log.error(msg, t);
                    continue;
                }
                log.error(msg, t);
            }
        }
        this.state = AcceptorState.ENDED;
    }

    private int handleExceptionWithDelay(int currentErrorDelay) {
        if (currentErrorDelay > 0) {
            try {
                Thread.sleep(currentErrorDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (currentErrorDelay == 0) {
            return 50;
        }
        if (currentErrorDelay < 1600) {
            return currentErrorDelay * 2;
        }
        return 1600;
    }

    public static enum AcceptorState {
        NEW,
        RUNNING,
        PAUSED,
        ENDED;

    }
}

