/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.BaseRemoteService;
import org.redisson.api.RFuture;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.RemoteExecutorService;
import org.redisson.executor.RemotePromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.remote.RemoteServiceCancelRequest;
import org.redisson.remote.RemoteServiceCancelResponse;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.RequestId;
import org.redisson.remote.ResponseEntry;

public class TasksService
extends BaseRemoteService {
    protected String terminationTopicName;
    protected String tasksCounterName;
    protected String statusName;
    protected String tasksName;

    public TasksService(Codec codec, RedissonClient redisson, String name, CommandAsyncExecutor commandExecutor, String executorId, ConcurrentMap<String, ResponseEntry> responses) {
        super(codec, redisson, name, commandExecutor, executorId, responses);
    }

    public void setTerminationTopicName(String terminationTopicName) {
        this.terminationTopicName = terminationTopicName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public void setTasksCounterName(String tasksCounterName) {
        this.tasksCounterName = tasksCounterName;
    }

    public void setTasksName(String tasksName) {
        this.tasksName = tasksName;
    }

    @Override
    protected final RFuture<Boolean> addAsync(String requestQueueName, RemoteServiceRequest request, RemotePromise<Object> result) {
        final RedissonPromise<Boolean> promise = new RedissonPromise<Boolean>();
        RFuture<Boolean> future = this.addAsync(requestQueueName, request);
        result.setAddFuture(future);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                if (!future.getNow().booleanValue()) {
                    promise.cancel(true);
                    return;
                }
                promise.trySuccess(true);
            }
        });
        return promise;
    }

    protected CommandAsyncExecutor getAddCommandExecutor() {
        return this.commandExecutor;
    }

    protected RFuture<Boolean> addAsync(String requestQueueName, RemoteServiceRequest request) {
        request.getArgs()[3] = request.getId();
        return this.getAddCommandExecutor().evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[2]) == 0 then redis.call('hset', KEYS[4], ARGV[1], ARGV[2]);redis.call('rpush', KEYS[3], ARGV[1]); redis.call('incr', KEYS[1]);return 1;end;return 0;", Arrays.asList(this.tasksCounterName, this.statusName, requestQueueName, this.tasksName), request.getId(), this.encode(request));
    }

    @Override
    protected RFuture<Boolean> removeAsync(String requestQueueName, RequestId taskId) {
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local task = redis.call('hget', KEYS[5], ARGV[1]); if task ~= false and redis.call('lrem', KEYS[1], 1, ARGV[1]) > 0 then redis.call('hdel', KEYS[5], ARGV[1]); if redis.call('decr', KEYS[2]) == 0 then redis.call('del', KEYS[2]);if redis.call('get', KEYS[3]) == ARGV[2] then redis.call('set', KEYS[3], ARGV[3]);redis.call('publish', KEYS[4], ARGV[3]);end;end;return 1;end;return 0;", Arrays.asList(requestQueueName, this.tasksCounterName, this.statusName, this.terminationTopicName, this.tasksName), taskId.toString(), 1, 2);
    }

    public RFuture<Boolean> cancelExecutionAsync(final RequestId requestId) {
        Class<RemoteExecutorService> syncInterface = RemoteExecutorService.class;
        if (!this.redisson.getMap(this.tasksName, LongCodec.INSTANCE).containsKey(requestId)) {
            return RedissonPromise.newSucceededFuture(false);
        }
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        String requestQueueName = this.getRequestQueueName(syncInterface);
        RFuture<Boolean> removeFuture = this.removeAsync(requestQueueName, requestId);
        removeFuture.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    result.trySuccess(true);
                } else {
                    RMap<String, RemoteServiceCancelRequest> canceledRequests = TasksService.this.redisson.getMap(TasksService.this.cancelRequestMapName, TasksService.this.codec);
                    canceledRequests.putAsync(requestId.toString(), new RemoteServiceCancelRequest(true, true));
                    canceledRequests.expireAsync(60L, TimeUnit.SECONDS);
                    final RedissonPromise response = new RedissonPromise();
                    TasksService.this.scheduleCheck(TasksService.this.cancelResponseMapName, requestId, response);
                    response.addListener(new FutureListener<RemoteServiceCancelResponse>(){

                        @Override
                        public void operationComplete(Future<RemoteServiceCancelResponse> future) throws Exception {
                            if (!future.isSuccess()) {
                                result.tryFailure(future.cause());
                                return;
                            }
                            if (response.getNow() == null) {
                                result.trySuccess(false);
                                return;
                            }
                            result.trySuccess(((RemoteServiceCancelResponse)response.getNow()).isCanceled());
                        }
                    });
                }
            }
        });
        return result;
    }
}

