/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Predicate;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class FluxFilterFuseable<T>
extends FluxOperator<T, T>
implements Fuseable {
    final Predicate<? super T> predicate;

    FluxFilterFuseable(Flux<? extends T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new FilterFuseableConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)actual, this.predicate));
            return;
        }
        this.source.subscribe(new FilterFuseableSubscriber<T>(actual, this.predicate));
    }

    static final class FilterFuseableConditionalSubscriber<T>
    implements InnerOperator<T, T>,
    Fuseable.ConditionalSubscriber<T>,
    Fuseable.QueueSubscription<T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final Predicate<? super T> predicate;
        Fuseable.QueueSubscription<T> s;
        boolean done;
        int sourceMode;

        FilterFuseableConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Predicate<? super T> predicate) {
            this.actual = actual;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                boolean b;
                if (this.done) {
                    Operators.onNextDropped(t, this.actual.currentContext());
                    return;
                }
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                    return;
                }
                if (b) {
                    this.actual.onNext(t);
                } else {
                    this.s.request(1L);
                }
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return false;
            }
            try {
                b = this.predicate.test(t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return false;
            }
            return b && this.actual.tryOnNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public T poll() {
            Object v;
            if (this.sourceMode == 2) {
                long dropped = 0L;
                while (true) {
                    Object v2;
                    if ((v2 = this.s.poll()) == null || this.predicate.test(v2)) {
                        if (dropped != 0L) {
                            this.request(dropped);
                        }
                        return (T)v2;
                    }
                    ++dropped;
                }
            }
            while ((v = this.s.poll()) != null && !this.predicate.test(v)) {
            }
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m;
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            this.sourceMode = m = this.s.requestFusion(requestedMode);
            return m;
        }
    }

    static final class FilterFuseableSubscriber<T>
    implements InnerOperator<T, T>,
    Fuseable.QueueSubscription<T>,
    Fuseable.ConditionalSubscriber<T> {
        final CoreSubscriber<? super T> actual;
        final Predicate<? super T> predicate;
        Fuseable.QueueSubscription<T> s;
        boolean done;
        int sourceMode;

        FilterFuseableSubscriber(CoreSubscriber<? super T> actual, Predicate<? super T> predicate) {
            this.actual = actual;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                boolean b;
                if (this.done) {
                    Operators.onNextDropped(t, this.actual.currentContext());
                    return;
                }
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                    return;
                }
                if (b) {
                    this.actual.onNext(t);
                } else {
                    this.s.request(1L);
                }
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return false;
            }
            try {
                b = this.predicate.test(t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return false;
            }
            if (b) {
                this.actual.onNext(t);
                return true;
            }
            return false;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public T poll() {
            Object v;
            if (this.sourceMode == 2) {
                long dropped = 0L;
                while (true) {
                    Object v2;
                    if ((v2 = this.s.poll()) == null || this.predicate.test(v2)) {
                        if (dropped != 0L) {
                            this.request(dropped);
                        }
                        return (T)v2;
                    }
                    ++dropped;
                }
            }
            while ((v = this.s.poll()) != null && !this.predicate.test(v)) {
            }
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m;
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            this.sourceMode = m = this.s.requestFusion(requestedMode);
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }
}

