/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsixface;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class YamlConfig {
    private Object content;
    private Pattern arrayKeyPattern = Pattern.compile("^([a-zA-Z][a-zA-Z0-9]+)\\[([0-9]+)]$");

    private YamlConfig() {
    }

    public static YamlConfig load(Reader reader) {
        YamlConfig instance = new YamlConfig();
        Yaml yml = new Yaml();
        instance.content = yml.load(reader);
        return instance;
    }

    public static YamlConfig load(InputStream in) {
        YamlConfig instance = new YamlConfig();
        Yaml yml = new Yaml();
        instance.content = yml.load(in);
        return instance;
    }

    public String getString(String key) {
        Object foundNode = this.getNode(key, this.content);
        if (foundNode != null && !(foundNode instanceof Collection)) {
            return foundNode.toString();
        }
        return null;
    }

    public Integer getInt(String key) {
        Object foundNode = this.getNode(key, this.content);
        if (foundNode instanceof Integer) {
            return (Integer)foundNode;
        }
        return null;
    }

    private Object getNode(String key, Object foundNode) {
        String[] parts;
        for (String part : parts = this.decompose(key)) {
            int arrayNum = -1;
            Matcher matcher = this.arrayKeyPattern.matcher(part);
            if (matcher.matches()) {
                part = matcher.group(1);
                arrayNum = Integer.parseInt(matcher.group(2));
            }
            if (!(foundNode instanceof Map)) continue;
            if (((Map)foundNode).containsKey(part)) {
                foundNode = ((Map)foundNode).get(part);
                if (arrayNum < 0) continue;
                if (foundNode instanceof ArrayList && ((ArrayList)foundNode).size() > arrayNum) {
                    foundNode = ((ArrayList)foundNode).get(arrayNum);
                    continue;
                }
                return null;
            }
            return null;
        }
        return foundNode;
    }

    private String[] decompose(String key) {
        return key.split("\\.");
    }
}

