/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate;

import com.github.jsontemplate.antlr4.JsonTemplateAntlrLexer;
import com.github.jsontemplate.antlr4.JsonTemplateAntlrParser;
import com.github.jsontemplate.jsonbuild.JsonBuilder;
import com.github.jsontemplate.jsonbuild.JsonNode;
import com.github.jsontemplate.jsonbuild.JsonWrapperNode;
import com.github.jsontemplate.modelbuild.BasePropertyDeclaration;
import com.github.jsontemplate.modelbuild.JsonTemplateTreeListener;
import com.github.jsontemplate.modelbuild.handler.DefaultJsonBuildHandler;
import com.github.jsontemplate.modelbuild.handler.DefaultTypeBuildHandler;
import com.github.jsontemplate.valueproducer.Base64ValueProducer;
import com.github.jsontemplate.valueproducer.BooleanValueProducer;
import com.github.jsontemplate.valueproducer.FloatValueProducer;
import com.github.jsontemplate.valueproducer.IValueProducer;
import com.github.jsontemplate.valueproducer.IntegerValueProducer;
import com.github.jsontemplate.valueproducer.IpValueProducer;
import com.github.jsontemplate.valueproducer.Ipv6ValueProducer;
import com.github.jsontemplate.valueproducer.RawStringValueProducer;
import com.github.jsontemplate.valueproducer.SmartValueProducer;
import com.github.jsontemplate.valueproducer.StringValueProducer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class JsonTemplate {
    private String defaultTypeName = "smart";
    private String template;
    private Map<String, Object> variableMap = new HashMap<String, Object>(32);
    private Map<String, IValueProducer> producerMap = new HashMap<String, IValueProducer>(32);
    private Map<String, JsonNode> variableNodeMap = new HashMap<String, JsonNode>(32);
    private JsonNode rootNode;

    public JsonTemplate(String template) {
        this.template = template;
        this.initializeProducerMap();
    }

    public JsonTemplate withVar(String variableName, Object variable) {
        this.variableMap.put(variableName, variable);
        return this;
    }

    public JsonTemplate withVars(Map<String, Object> variables) {
        variables.forEach(this::withVar);
        return this;
    }

    public JsonTemplate withValueProducer(IValueProducer valueProducer) {
        this.addProducer(valueProducer);
        return this;
    }

    public JsonTemplate withDefaultTypeName(String typeName) {
        this.defaultTypeName = typeName;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public String compactString() {
        this.build();
        return this.rootNode.compactString();
    }

    public String prettyString() {
        this.build();
        return this.rootNode.prettyString(0);
    }

    private void initializeProducerMap() {
        IValueProducer[] producers = new IValueProducer[]{new SmartValueProducer(), new StringValueProducer(), new IntegerValueProducer(), new BooleanValueProducer(), new FloatValueProducer(), new IpValueProducer(), new Ipv6ValueProducer(), new Base64ValueProducer(), new RawStringValueProducer()};
        Arrays.stream(producers).forEach(this::addProducer);
    }

    private void addProducer(IValueProducer producer) {
        this.producerMap.put(producer.getTypeName(), producer);
    }

    private void build() {
        if (this.template == null) {
            throw new IllegalArgumentException("Template is not set.");
        }
        if (this.rootNode == null) {
            this.rootNode = this.buildJsonNode(this.template);
        }
    }

    private JsonNode buildJsonNode(String template) {
        this.buildVariableNodeMap();
        JsonTemplateTreeListener listener = this.parse(template);
        BasePropertyDeclaration rootDeclaration = listener.getJsonRoot();
        Map<String, JsonNode> typeMap = this.buildTypeMap(listener.getTypeDefinitionList());
        rootDeclaration.applyVariablesToParameters(this.variableMap);
        JsonBuilder builder = new JsonBuilder();
        rootDeclaration.buildJsonTemplate(builder, this.producerMap, typeMap, this.variableNodeMap, this.defaultTypeName, new DefaultJsonBuildHandler());
        return builder.build();
    }

    private void buildVariableNodeMap() {
        this.variableMap.forEach((key, value) -> this.variableNodeMap.put((String)key, JsonNode.of(value)));
    }

    private JsonTemplateTreeListener parse(String template) {
        JsonTemplateAntlrLexer jsonTemplateLexer = new JsonTemplateAntlrLexer((CharStream)CharStreams.fromString((String)template));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)jsonTemplateLexer);
        JsonTemplateAntlrParser parser = new JsonTemplateAntlrParser((TokenStream)commonTokenStream);
        JsonTemplateTreeListener listener = new JsonTemplateTreeListener();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)listener, (ParseTree)parser.root());
        return listener;
    }

    private Map<String, JsonNode> buildTypeMap(List<BasePropertyDeclaration> typeDeclarations) {
        HashMap<String, JsonNode> typeMap = new HashMap<String, JsonNode>();
        HashMap<String, List<JsonWrapperNode>> missTypeMap = new HashMap<String, List<JsonWrapperNode>>();
        for (BasePropertyDeclaration basePropertyDeclaration : typeDeclarations) {
            JsonBuilder jsonBuilder = new JsonBuilder();
            basePropertyDeclaration.buildJsonTemplate(jsonBuilder, this.producerMap, typeMap, this.variableNodeMap, this.defaultTypeName, new DefaultTypeBuildHandler(missTypeMap));
            JsonNode typeNode = jsonBuilder.build();
            typeMap.put(basePropertyDeclaration.getPropertyName(), typeNode);
        }
        for (Map.Entry entry : missTypeMap.entrySet()) {
            JsonNode jsonNode = (JsonNode)typeMap.get(entry.getKey());
            for (JsonWrapperNode jsonWrapperNode : (List)entry.getValue()) {
                jsonWrapperNode.setJsonNode(jsonNode);
            }
        }
        return typeMap;
    }
}

