/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.valueproducer;

import com.github.jsontemplate.jsonbuild.JsonStringNode;
import com.github.jsontemplate.valueproducer.AbstractValueProducer;
import com.github.jsontemplate.valueproducer.StringValueProducer;
import java.util.Base64;
import java.util.Map;

public class Base64ValueProducer
extends AbstractValueProducer<JsonStringNode> {
    public static final String TYPE_NAME = "base64";
    private static final int DEFAULT_LENGTH = 12;
    private static final int THREE_BYTES = 3;
    private static final int FOUR_BASE64_CHARS = 4;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public JsonStringNode produce() {
        return new JsonStringNode(() -> this.produceBase64(this.getDefaultLength()));
    }

    @Override
    public JsonStringNode produce(Map<String, String> paramMap) {
        Integer length = this.pickIntegerParam(paramMap, "length");
        return new JsonStringNode(() -> this.produceBase64(length));
    }

    protected String produceBase64(int outputLength) {
        int originalLength = outputLength * 3 / 4;
        if (outputLength % 4 != 0) {
            ++originalLength;
        }
        String originalString = new StringValueProducer().produceString(originalLength);
        return Base64.getEncoder().encodeToString(originalString.getBytes());
    }

    protected int getDefaultLength() {
        return 12;
    }
}

