/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.valueproducer;

import com.github.jsontemplate.jsonbuild.JsonStringNode;
import com.github.jsontemplate.jsonbuild.supplier.ListParamSupplier;
import com.github.jsontemplate.valueproducer.AbstractValueProducer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;

public class StringValueProducer
extends AbstractValueProducer<JsonStringNode> {
    public static final String TYPE_NAME = "s";
    private static final String ALPHABETIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final int DEFAULT_LENGTH = 5;
    private static final int DEFAULT_MIN_LENGTH = 0;
    private Random random = new Random();

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public JsonStringNode produce() {
        return new JsonStringNode(() -> this.produceString(this.getDefaultLength()));
    }

    @Override
    public JsonStringNode produce(String value) {
        return new JsonStringNode(() -> value);
    }

    @Override
    public JsonStringNode produce(List<String> valueList) {
        return new JsonStringNode((Supplier<String>)new ListParamSupplier<String>(valueList));
    }

    @Override
    public JsonStringNode produce(Map<String, String> paramMap) {
        HashMap<String, String> copyParamMap = new HashMap<String, String>(paramMap);
        Integer length = this.pickIntegerParam(copyParamMap, "length");
        Integer min = this.pickIntegerParam(copyParamMap, "min");
        Integer max = this.pickIntegerParam(copyParamMap, "max");
        this.validateParamMap(copyParamMap);
        if (length != null) {
            this.shouldBePositive(length, "length");
            return new JsonStringNode(() -> this.produceString(length));
        }
        if (min != null && max != null) {
            this.shouldBePositive(min, "min");
            this.shouldBePositive(max, "max");
            this.shouldBeInAscOrder(min, max, "min", "max");
            return new JsonStringNode(() -> this.produceString(this.randomIntInRange(min, max)));
        }
        if (min != null) {
            this.shouldBePositive(min, "min");
            return new JsonStringNode(() -> this.produceString(this.randomIntInRange(min, this.getDefaultMax(min))));
        }
        if (max != null) {
            this.shouldBePositive(max, "max");
            return new JsonStringNode(() -> this.produceString(this.randomIntInRange(this.getDefaultMin(max), max)));
        }
        return this.produce();
    }

    protected int getDefaultLength() {
        return 5;
    }

    protected int getDefaultMax(int min) {
        return 2 * min;
    }

    protected int getDefaultMin(int max) {
        return 0;
    }

    public String produceString(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int index = this.random.nextInt(ALPHABETIC.length());
            chars[i] = ALPHABETIC.charAt(index);
        }
        return new String(chars);
    }
}

