/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtendermint.merkletree;

import com.github.jtendermint.crypto.ByteUtil;
import com.github.jtendermint.crypto.HashFunction;
import com.github.jtendermint.crypto.RipeMD160;
import com.github.jtendermint.merkletree.AddResult;
import com.github.jtendermint.merkletree.HashWithCount;
import com.github.jtendermint.merkletree.IterateFunction;
import com.github.jtendermint.merkletree.KeyIndex;
import com.github.jtendermint.merkletree.byteable.types.IByteable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public class MerkleNode<K extends IByteable> {
    private K key;
    private int height;
    private int size;
    private byte[] hash;
    private byte[] leftChildHash;
    private byte[] rightChildHash;
    private MerkleNode<K> leftChildNode;
    private MerkleNode<K> rightChildNode;
    protected HashFunction hashFunction = new RipeMD160();

    public MerkleNode(K key) {
        this(key, 0, 1, null, null, null, null);
    }

    public MerkleNode(K key, MerkleNode<K> leftNode, MerkleNode<K> rightNode) {
        this(key, 1, 2, null, leftNode, null, rightNode);
    }

    private MerkleNode(K key, int height, int size, byte[] leftHash, MerkleNode<K> leftNode, byte[] rightHash, MerkleNode<K> rightNode) {
        this.key = key;
        this.height = height;
        this.size = size;
        this.hash = null;
        this.leftChildHash = leftHash == null ? null : Arrays.copyOf(leftHash, leftHash.length);
        this.leftChildNode = leftNode;
        this.rightChildHash = rightHash == null ? null : Arrays.copyOf(rightHash, rightHash.length);
        this.rightChildNode = rightNode;
    }

    public K getKey() {
        return this.key;
    }

    public int getSize() {
        return this.size;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean contains(K entry) {
        return this.get(entry) != null;
    }

    public KeyIndex<K> get(int index) {
        if (this.height == 0) {
            if (index == 0) {
                return new KeyIndex<K>(this.key, true, 0);
            }
            throw new RuntimeException("Asked for index > 0 with a height of 0");
        }
        if (index < this.leftChildNode.size) {
            return this.leftChildNode.get(index);
        }
        return this.rightChildNode.get(index - this.leftChildNode.size);
    }

    public K get(K entry) {
        if (entry != null && entry.equals(this.key)) {
            return this.key;
        }
        if (this.height == 0) {
            return null;
        }
        if (entry.compareTo((IByteable)this.key) < 0) {
            return this.leftChildNode.get(entry);
        }
        return this.rightChildNode.get(entry);
    }

    public AddResult<K> add(K entry) {
        AddResult<K> newNodeResult;
        int compareResult = entry.compareTo((IByteable)this.key);
        if (this.height == 0) {
            if (compareResult < 0) {
                MerkleNode<K> newNode = new MerkleNode<K>(this.key, this.createNode(entry), this);
                return new AddResult<K>(newNode, false);
            }
            if (compareResult == 0) {
                return new AddResult<K>(this.createNode(entry), true);
            }
            MerkleNode<K> newNode = new MerkleNode<K>(entry, this, this.createNode(entry));
            return new AddResult<K>(newNode, false);
        }
        MerkleNode<K> newNode = this.createCopy();
        if (entry.compareTo((IByteable)newNode.key) < 0) {
            newNodeResult = newNode.leftChildNode.add(entry);
            newNode.leftChildNode = newNodeResult.getNode();
            newNode.leftChildHash = null;
        } else {
            newNodeResult = newNode.rightChildNode.add(entry);
            newNode.rightChildNode = newNodeResult.getNode();
            newNode.rightChildHash = null;
        }
        if (newNodeResult.wasUpdated()) {
            return new AddResult<K>(newNode, true);
        }
        super.updateHeightAndSize();
        return new AddResult<K>(super.balance(), false);
    }

    private MerkleNode<K> balance() {
        int balance = this.getBalance();
        if (balance > 1) {
            if (super.getBalance() >= 0) {
                return this.rotateRight();
            }
            MerkleNode<K> newNode = this.createCopy();
            newNode.leftChildHash = null;
            newNode.leftChildNode = super.rotateLeft();
            return super.rotateRight();
        }
        if (balance < -1) {
            if (super.getBalance() <= 0) {
                return this.rotateLeft();
            }
            MerkleNode<K> newNode = this.createCopy();
            newNode.rightChildHash = null;
            newNode.rightChildNode = super.rotateRight();
            return super.rotateLeft();
        }
        return this;
    }

    private MerkleNode<K> rotateLeft() {
        MerkleNode<K> newNode = this.createCopy();
        MerkleNode<K> rightCopy = newNode.rightChildNode.createCopy();
        newNode.rightChildHash = rightCopy.leftChildHash;
        newNode.rightChildNode = rightCopy.leftChildNode;
        rightCopy.leftChildNode = newNode;
        super.updateHeightAndSize();
        super.updateHeightAndSize();
        return rightCopy;
    }

    private MerkleNode<K> rotateRight() {
        MerkleNode<K> newNode = this.createCopy();
        MerkleNode<K> leftCopy = newNode.leftChildNode.createCopy();
        newNode.leftChildHash = leftCopy.rightChildHash;
        newNode.leftChildNode = leftCopy.rightChildNode;
        leftCopy.rightChildHash = null;
        leftCopy.rightChildNode = newNode;
        super.updateHeightAndSize();
        super.updateHeightAndSize();
        return leftCopy;
    }

    private int getBalance() {
        return this.leftChildNode.height - this.rightChildNode.height;
    }

    private void updateHeightAndSize() {
        this.height = Math.max(this.leftChildNode.getHeight(), this.rightChildNode.getHeight()) + 1;
        this.size = this.leftChildNode.getSize() + this.rightChildNode.getSize();
    }

    public boolean remove(K entry) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashWithCount getHashWithCount() {
        if (this.hash != null) {
            return new HashWithCount(this.hash, 0);
        }
        try (ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();){
            int hashCount = this.writeHashBytes(byteOutStream);
            this.hash = this.hashFunction.hashBytes(byteOutStream.toByteArray());
            HashWithCount hashWithCount = new HashWithCount(this.hash, hashCount + 1);
            return hashWithCount;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private int writeHashBytes(ByteArrayOutputStream bos) throws IOException {
        int hashCount = 0;
        bos.write((byte)this.height);
        ByteUtil.writeWithVarint((byte[])BigInteger.valueOf(this.size).toByteArray(), (ByteArrayOutputStream)bos);
        if (this.height == 0) {
            ByteUtil.writeWithVarint((byte[])this.key.toByteArray(), (ByteArrayOutputStream)bos);
        } else {
            if (this.leftChildNode != null) {
                HashWithCount leftHashCount = this.leftChildNode.getHashWithCount();
                this.leftChildHash = Objects.requireNonNull(leftHashCount.hash, "this.leftHash was null in writeHashBytes");
                hashCount += leftHashCount.count;
            }
            ByteUtil.writeWithVarint((byte[])this.leftChildHash, (ByteArrayOutputStream)bos);
            if (this.rightChildNode != null) {
                HashWithCount rightHashCount = this.rightChildNode.getHashWithCount();
                this.rightChildHash = Objects.requireNonNull(rightHashCount.hash, "this.rightHash was null in writeHashBytes");
                hashCount += rightHashCount.count;
            }
            ByteUtil.writeWithVarint((byte[])this.rightChildHash, (ByteArrayOutputStream)bos);
        }
        return hashCount;
    }

    public byte[] save() {
        if (this.hash == null) {
            this.hash = this.getHashWithCount().hash;
        }
        if (this.leftChildNode != null) {
            this.leftChildHash = this.leftChildNode.save();
        }
        if (this.rightChildNode != null) {
            this.rightChildHash = this.rightChildNode.save();
        }
        return Arrays.copyOf(this.hash, this.hash.length);
    }

    public MerkleNode<K> createCopy() {
        if (this.height == 0) {
            throw new RuntimeException("Cannot copy Value-Nodes");
        }
        return new MerkleNode<K>(this.key, this.height, this.size, this.leftChildHash, this.leftChildNode, this.rightChildHash, this.rightChildNode);
    }

    public String toPrettyString() {
        if (this.height == 0) {
            return String.valueOf(new BigInteger(this.key.toByteArray()).intValue());
        }
        return "(" + this.leftChildNode.toPrettyString() + " " + this.rightChildNode.toPrettyString() + ")";
    }

    public boolean isLeafNode() {
        return this.height == 0;
    }

    public boolean iterateNodes(IterateFunction<K> func) {
        boolean stop = func.currentNode(this);
        if (stop) {
            return true;
        }
        if (this.height > 0) {
            stop = this.leftChildNode.iterateNodes(func);
            if (stop) {
                return true;
            }
            stop = this.rightChildNode.iterateNodes(func);
            if (stop) {
                return true;
            }
        }
        return false;
    }

    protected MerkleNode<K> createNode(K entry) {
        return new MerkleNode<K>(entry);
    }
}

