/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtendermint.merkletree;

import com.github.jtendermint.merkletree.AddResult;
import com.github.jtendermint.merkletree.HashWithCount;
import com.github.jtendermint.merkletree.IMerkleTree;
import com.github.jtendermint.merkletree.IterateFunction;
import com.github.jtendermint.merkletree.KeyIndex;
import com.github.jtendermint.merkletree.MerkleNode;
import com.github.jtendermint.merkletree.RemoveResult;
import com.github.jtendermint.merkletree.byteable.types.IByteable;
import java.util.Arrays;

public class MerkleTree<K extends IByteable>
implements IMerkleTree<K> {
    private MerkleNode<K> rootNode;

    @Override
    public int size() {
        return this.rootNode == null ? 0 : this.rootNode.getSize();
    }

    @Override
    public int getHeight() {
        return this.rootNode == null ? 0 : this.rootNode.getHeight();
    }

    @Override
    public boolean contains(K key) {
        return this.rootNode == null ? false : this.rootNode.contains(key);
    }

    @Override
    public K get(K entry) {
        return this.rootNode == null ? null : (K)this.rootNode.get(entry);
    }

    @Override
    public KeyIndex<K> get(int index) {
        return this.rootNode == null ? null : (Object)this.rootNode.get((K)index);
    }

    @Override
    public boolean add(K entry) {
        if (this.rootNode == null) {
            this.rootNode = this.createNode(entry);
            return false;
        }
        AddResult<K> result = this.rootNode.add(entry);
        this.rootNode = result.getNode();
        return result.wasUpdated();
    }

    @Override
    public RemoveResult<K> remove(K key) {
        if (this.rootNode == null) {
            return null;
        }
        boolean result = this.rootNode.remove(key);
        return null;
    }

    @Override
    public HashWithCount getHashWithCount() {
        HashWithCount result = new HashWithCount(null, 0);
        if (this.rootNode != null) {
            result = this.rootNode.getHashWithCount();
        }
        return result;
    }

    @Override
    public byte[] getRootHash() {
        if (this.rootNode == null) {
            return null;
        }
        byte[] rootHash = this.rootNode.getHashWithCount().hash;
        return rootHash != null ? Arrays.copyOf(rootHash, rootHash.length) : null;
    }

    @Override
    public MerkleNode<K> getRoot() {
        return this.rootNode;
    }

    @Override
    public String toPrettyString() {
        if (this.rootNode == null) {
            return "()";
        }
        return this.rootNode.toPrettyString();
    }

    @Override
    public boolean iterateNodes(IterateFunction<K> function) {
        if (this.rootNode != null) {
            return this.rootNode.iterateNodes(function);
        }
        return false;
    }

    protected MerkleNode<K> createNode(K entry) {
        return new MerkleNode<K>(entry);
    }
}

