/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtendermint.merkletree;

import com.github.jtendermint.merkletree.MerkleNode;
import com.github.jtendermint.merkletree.byteable.types.IByteable;
import java.util.Arrays;

public class RemoveResult<K extends IByteable> {
    private MerkleNode<K> node;
    private byte[] hash;
    private final IByteable byteable;
    private final boolean removed;

    public RemoveResult(byte[] hash, MerkleNode<K> node, K byteable, boolean removed) {
        this.hash = Arrays.copyOf(hash, hash.length);
        this.node = node;
        this.byteable = byteable;
        this.removed = removed;
    }

    public RemoveResult(K byteable, boolean removed) {
        this.byteable = byteable == null ? null : byteable;
        this.removed = removed;
    }

    public MerkleNode<K> getNode() {
        return this.node;
    }

    public byte[] getHash() {
        return this.hash != null ? Arrays.copyOf(this.hash, this.hash.length) : null;
    }

    public boolean wasRemoved() {
        return this.removed;
    }

    public IByteable getByteable() {
        return this.byteable;
    }
}

