/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtendermint.merkletree.byteable.types;

import com.github.jtendermint.merkletree.byteable.types.IByteable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteableLong
implements IByteable {
    public final long value;
    private final byte[] bytes;

    public ByteableLong(long value) {
        this.value = value;
        this.bytes = this.calcByteArray(value);
    }

    @Override
    public byte[] toByteArray() {
        return this.bytes != null ? Arrays.copyOf(this.bytes, this.bytes.length) : null;
    }

    private byte[] calcByteArray(long value) {
        byte[] b = ByteBuffer.allocate(8).putLong(value).array();
        int startOffset = 0;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == 0) continue;
            startOffset = i;
            break;
        }
        return Arrays.copyOfRange(b, startOffset, b.length);
    }

    @Override
    public int compareTo(IByteable other) {
        if (other instanceof ByteableLong) {
            return Long.compare(this.value, ((ByteableLong)other).value);
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ByteableLong) {
            return this.value == ((ByteableLong)obj).value;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }
}

