/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtendermint.merkletree.byteable.types;

import com.github.jtendermint.merkletree.byteable.types.IByteable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Objects;

public class ByteableString
implements IByteable {
    public String string;

    public ByteableString(String s) {
        this.string = s;
    }

    public ByteableString(byte[] bytes) {
        try {
            this.string = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 conversion failed.", e);
        }
    }

    @Override
    public byte[] toByteArray() {
        return this.string.getBytes(Charset.forName("UTF-8"));
    }

    @Override
    public int compareTo(IByteable other) {
        if (other instanceof ByteableString) {
            return this.string.compareTo(((ByteableString)other).string);
        }
        return -1;
    }

    public String toString() {
        return this.string;
    }

    public int hashCode() {
        if (this.string == null) {
            return 0;
        }
        return this.string.hashCode();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof ByteableString) {
            ByteableString other = (ByteableString)arg0;
            return Objects.equals(this.string, other.string);
        }
        return false;
    }
}

