/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtendermint.merkletree.iavl;

import com.github.jtendermint.merkletree.HashWithCount;
import com.github.jtendermint.merkletree.iavl.AddResult;
import com.github.jtendermint.merkletree.iavl.Hashing;
import com.github.jtendermint.merkletree.iavl.IterateFunct;
import com.github.jtendermint.merkletree.iavl.KeyIndex;
import com.github.jtendermint.merkletree.iavl.Node;
import java.util.Arrays;

public class AVLTree<K extends Comparable<K>> {
    private final Hashing<K> hashalgorithm;
    private Node<K> rootNode;

    public AVLTree(Hashing<K> hashalgorithm) {
        this.hashalgorithm = hashalgorithm;
    }

    public int size() {
        return this.rootNode == null ? 0 : this.rootNode.getSize();
    }

    public int getHeight() {
        return this.rootNode == null ? 0 : this.rootNode.getHeight();
    }

    public boolean contains(K entry) {
        return this.rootNode == null ? false : this.rootNode.contains(entry);
    }

    public K get(K entry) {
        return this.rootNode == null ? null : (K)this.rootNode.get(entry);
    }

    public KeyIndex<K> get(int index) {
        return this.rootNode == null ? null : this.rootNode.get(index);
    }

    public boolean add(K entry) {
        if (this.rootNode == null) {
            this.rootNode = new Node<K>().init(entry).setHashFunction(this.hashalgorithm);
            return false;
        }
        AddResult<K> result = this.rootNode.add(entry);
        this.rootNode = result.getNode();
        return result.wasUpdated();
    }

    public HashWithCount getHashWithCount() {
        if (this.rootNode != null) {
            return this.rootNode.getHashWithCount();
        }
        return new HashWithCount(null, 0);
    }

    public byte[] getRootHash() {
        if (this.rootNode == null) {
            return null;
        }
        byte[] rootHash = this.rootNode.getHashWithCount().hash;
        return rootHash != null ? Arrays.copyOf(rootHash, rootHash.length) : null;
    }

    public Node<K> getRoot() {
        return this.rootNode;
    }

    public String toPrettyString() {
        if (this.rootNode == null) {
            return "()";
        }
        return this.rootNode.toPrettyString();
    }

    public IterateFunct.Loop iterateNodes(IterateFunct<K> function) {
        if (this.rootNode != null) {
            return this.rootNode.iterateNodes(function);
        }
        return IterateFunct.Loop.STOP;
    }
}

