/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtendermint.merkletree.iavl;

import com.github.jtendermint.merkletree.HashWithCount;
import com.github.jtendermint.merkletree.iavl.AddResult;
import com.github.jtendermint.merkletree.iavl.Hashing;
import com.github.jtendermint.merkletree.iavl.IterateFunct;
import com.github.jtendermint.merkletree.iavl.KeyIndex;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class Node<K extends Comparable<K>> {
    private K value;
    private int height;
    private int size;
    private byte[] hash;
    private byte[] leftChildHash;
    private byte[] rightChildHash;
    private Node<K> leftChildNode;
    private Node<K> rightChildNode;
    private Hashing<K> hashFunction;

    public Node<K> init(K value) {
        return this.init(value, 0, 1, null, null, null, null);
    }

    public Node<K> init(K key, Node<K> leftNode, Node<K> rightNode) {
        return this.init(key, 1, 2, null, leftNode, null, rightNode);
    }

    public Node<K> init(K value, int height, int size, byte[] leftHash, Node<K> leftNode, byte[] rightHash, Node<K> rightNode) {
        this.value = value;
        this.height = height;
        this.size = size;
        this.hash = null;
        this.leftChildHash = leftHash == null ? null : Arrays.copyOf(leftHash, leftHash.length);
        this.leftChildNode = leftNode;
        this.rightChildHash = rightHash == null ? null : Arrays.copyOf(rightHash, rightHash.length);
        this.rightChildNode = rightNode;
        return this;
    }

    public K getValue() {
        return this.value;
    }

    public Node<K> setHashFunction(Hashing<K> hash) {
        this.hashFunction = hash;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSize() {
        return this.size;
    }

    public boolean contains(K value) {
        return this.get(value) != null;
    }

    public K get(K entry) {
        if (entry != null && entry.equals(this.value)) {
            return this.value;
        }
        if (this.height == 0) {
            return null;
        }
        if (entry.compareTo(this.value) < 0) {
            return this.leftChildNode.get(entry);
        }
        return this.rightChildNode.get(entry);
    }

    public KeyIndex<K> get(int index) {
        if (this.height == 0) {
            if (index == 0) {
                return new KeyIndex<K>(this.value, true, 0);
            }
            throw new RuntimeException("Asked for index > 0 with a height of 0");
        }
        if (index < this.leftChildNode.size) {
            return this.leftChildNode.get(index);
        }
        return this.rightChildNode.get(index - this.leftChildNode.size);
    }

    public AddResult<K> add(K value) {
        AddResult<K> newNodeResult;
        int compareResult = value.compareTo(this.value);
        if (this.height == 0) {
            if (compareResult < 0) {
                Node<K> newNode = new Node<K>();
                newNode.init(this.value, this.newNode().init(value).setHashFunction(this.hashFunction), this).setHashFunction(this.hashFunction);
                return new AddResult<K>(newNode, false);
            }
            if (compareResult == 0) {
                return new AddResult<K>(this.newNode().init(value).setHashFunction(this.hashFunction), true);
            }
            Node<K> newNode = new Node<K>();
            newNode.init(value, this, this.newNode().init(value).setHashFunction(this.hashFunction)).setHashFunction(this.hashFunction);
            return new AddResult<K>(newNode, false);
        }
        Node<K> newNode = this.createCopy();
        if (value.compareTo(newNode.value) < 0) {
            newNodeResult = newNode.leftChildNode.add(value);
            newNode.leftChildNode = newNodeResult.getNode();
            newNode.leftChildHash = null;
        } else {
            newNodeResult = newNode.rightChildNode.add(value);
            newNode.rightChildNode = newNodeResult.getNode();
            newNode.rightChildHash = null;
        }
        if (newNodeResult.wasUpdated()) {
            return new AddResult<K>(newNode, true);
        }
        super.updateHeightAndSize();
        return new AddResult<K>(super.balance(), false);
    }

    public boolean remove(K entry) {
        return false;
    }

    private Node<K> balance() {
        int balance = this.getBalance();
        if (balance > 1) {
            if (super.getBalance() >= 0) {
                return this.rotateRight();
            }
            Node<K> newNode = this.createCopy();
            newNode.leftChildHash = null;
            newNode.leftChildNode = super.rotateLeft();
            return super.rotateRight();
        }
        if (balance < -1) {
            if (super.getBalance() <= 0) {
                return this.rotateLeft();
            }
            Node<K> newNode = this.createCopy();
            newNode.rightChildHash = null;
            newNode.rightChildNode = super.rotateRight();
            return super.rotateLeft();
        }
        return this;
    }

    private Node<K> rotateLeft() {
        Node<K> newNode = this.createCopy();
        Node<K> rightCopy = newNode.rightChildNode.createCopy();
        newNode.rightChildHash = rightCopy.leftChildHash;
        newNode.rightChildNode = rightCopy.leftChildNode;
        rightCopy.leftChildNode = newNode;
        super.updateHeightAndSize();
        super.updateHeightAndSize();
        return rightCopy;
    }

    private Node<K> rotateRight() {
        Node<K> newNode = this.createCopy();
        Node<K> leftCopy = newNode.leftChildNode.createCopy();
        newNode.leftChildHash = leftCopy.rightChildHash;
        newNode.leftChildNode = leftCopy.rightChildNode;
        leftCopy.rightChildHash = null;
        leftCopy.rightChildNode = newNode;
        super.updateHeightAndSize();
        super.updateHeightAndSize();
        return leftCopy;
    }

    private int getBalance() {
        return this.leftChildNode.height - this.rightChildNode.height;
    }

    private void updateHeightAndSize() {
        this.height = Math.max(this.leftChildNode.getHeight(), this.rightChildNode.getHeight()) + 1;
        this.size = this.leftChildNode.getSize() + this.rightChildNode.getSize();
    }

    public Node<K> createCopy() {
        if (this.height == 0) {
            throw new RuntimeException("Cannot copy Value-Nodes");
        }
        return this.newNode().init(this.value, this.height, this.size, this.leftChildHash, this.leftChildNode, this.rightChildHash, this.rightChildNode).setHashFunction(this.hashFunction);
    }

    public String toPrettyString() {
        if (this.height == 0) {
            return String.valueOf(this.value);
        }
        return "(" + this.leftChildNode.toPrettyString() + " " + this.rightChildNode.toPrettyString() + ")";
    }

    public boolean isLeafNode() {
        return this.height == 0;
    }

    public IterateFunct.Loop iterateNodes(IterateFunct<K> func) {
        IterateFunct.Loop stop = func.currentNode(this);
        if (stop == IterateFunct.Loop.STOP) {
            return stop;
        }
        if (this.height > 0) {
            stop = this.leftChildNode.iterateNodes(func);
            if (stop == IterateFunct.Loop.STOP) {
                return IterateFunct.Loop.STOP;
            }
            stop = this.rightChildNode.iterateNodes(func);
            if (stop == IterateFunct.Loop.STOP) {
                return IterateFunct.Loop.STOP;
            }
        }
        return IterateFunct.Loop.CONTINUE;
    }

    protected Node<K> newNode() {
        return new Node<K>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashWithCount getHashWithCount() {
        if (this.hash != null) {
            return new HashWithCount(this.hash, 0);
        }
        try (ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();){
            int hashCount = this.writeHashBytes(byteOutStream);
            this.hash = this.hashFunction.hashBytes(byteOutStream.toByteArray());
            HashWithCount hashWithCount = new HashWithCount(this.hash, hashCount + 1);
            return hashWithCount;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private int writeHashBytes(ByteArrayOutputStream bos) throws IOException {
        int hashCount = 0;
        if (this.height == 0) {
            byte[] hashBytes = this.hashFunction.hashBytes(this.value);
            bos.write(hashBytes);
        } else {
            if (this.leftChildNode != null) {
                HashWithCount leftHashCount = this.leftChildNode.getHashWithCount();
                this.leftChildHash = Objects.requireNonNull(leftHashCount.hash, "this.leftHash was null in writeHashBytes");
                hashCount += leftHashCount.count;
            }
            if (this.rightChildNode != null) {
                HashWithCount rightHashCount = this.rightChildNode.getHashWithCount();
                this.rightChildHash = Objects.requireNonNull(rightHashCount.hash, "this.rightHash was null in writeHashBytes");
                hashCount += rightHashCount.count;
            }
            byte[] hashBytesRight = this.hashFunction.hashBytes(this.rightChildHash);
            byte[] hashBytesLeft = this.hashFunction.hashBytes(this.leftChildHash);
            bos.write(hashBytesLeft);
            bos.write(hashBytesRight);
        }
        return hashCount;
    }

    public byte[] save() {
        if (this.hash == null) {
            this.hash = this.getHashWithCount().hash;
        }
        if (this.leftChildNode != null) {
            this.leftChildHash = this.leftChildNode.save();
        }
        if (this.rightChildNode != null) {
            this.rightChildHash = this.rightChildNode.save();
        }
        return Arrays.copyOf(this.hash, this.hash.length);
    }
}

