/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtendermint.merkletree.iavl;

import com.github.jtendermint.merkletree.iavl.Node;
import java.util.Arrays;

public class RmResult<K extends Comparable<K>> {
    private final Node<K> node;
    private final byte[] hash;
    private final K value;
    private final boolean removed;

    public RmResult(byte[] hash, Node<K> node, K value, boolean removed) {
        this.hash = Arrays.copyOf(hash, hash.length);
        this.node = node;
        this.value = value;
        this.removed = removed;
    }

    public Node<K> getNode() {
        return this.node;
    }

    public byte[] getHash() {
        return this.hash != null ? Arrays.copyOf(this.hash, this.hash.length) : null;
    }

    public K getValue() {
        return this.value;
    }

    public boolean isRemoved() {
        return this.removed;
    }
}

