/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimeZone;
import net.logstash.logback.data.HostData;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class EventFormatter {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final FastDateFormat ISO8601_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)UTC);
    private String message;
    private String timestamp;
    private String sourceHost;
    private String level;
    private String loggerName;
    private String threadName;
    private Map<String, String> mdc;
    private boolean exceptionInfo;
    private String stackTrace;
    private String exceptionClass;
    private String exceptionMessage;
    private String fileName;
    private String lineNumber;
    private String className;
    private String methodName;
    private IThrowableProxy throwableProxy;
    private StackTraceElement[] stackTraceElement;
    private StackTraceElementProxy[] stackTraceElementProxy;

    public EventFormatter(ILoggingEvent loggingEvent) {
        this.message = loggingEvent.getMessage();
        this.timestamp = EventFormatter.dateFormat(loggingEvent.getTimeStamp());
        this.sourceHost = new HostData().getHostName();
        this.loggerName = loggingEvent.getLoggerName();
        this.threadName = loggingEvent.getThreadName();
        this.level = loggingEvent.getLevel().toString();
        this.mdc = loggingEvent.getMDCPropertyMap();
        this.throwableProxy = loggingEvent.getThrowableProxy();
        if (this.throwableProxy != null) {
            ArrayList<String> stackTraceElements = new ArrayList<String>();
            for (StackTraceElementProxy stackTraceElement : this.throwableProxy.getStackTraceElementProxyArray()) {
                stackTraceElements.add(stackTraceElement.getSTEAsString());
            }
            this.stackTrace = StringUtils.join((Object[])stackTraceElements.toArray(), (String)"\n");
            this.exceptionClass = this.throwableProxy.getClassName();
            this.exceptionMessage = this.throwableProxy.getMessage();
            this.exceptionInfo = true;
        }
        this.stackTraceElement = loggingEvent.getCallerData();
        this.fileName = this.stackTraceElement[0].getFileName();
        this.lineNumber = String.valueOf(this.stackTraceElement[0].getLineNumber());
        this.className = this.stackTraceElement[0].getClassName();
        this.methodName = this.stackTraceElement[0].getMethodName();
    }

    public static String dateFormat(long timestamp) {
        return ISO8601_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(timestamp);
    }

    public String getMessage() {
        return this.message;
    }

    public String getTimeStamp() {
        return this.timestamp;
    }

    public String getSourceHost() {
        return this.sourceHost;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getLevel() {
        return this.level;
    }

    public Map<String, String> getMDC() {
        return this.mdc;
    }

    public boolean hasExceptionInfo() {
        return this.exceptionInfo;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String getExceptionClass() {
        return this.exceptionClass;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }
}

