/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.LayoutBase;
import java.util.HashMap;
import net.logstash.logback.EventFormatter;
import net.minidev.json.JSONObject;

public class JSONEventLayoutV0
extends LayoutBase<ILoggingEvent> {
    private boolean locationInfo;
    private HashMap<String, Object> fields;
    private HashMap<String, Object> exception;
    private EventFormatter event;
    private JSONObject logstashEvent;

    public JSONEventLayoutV0() {
        this(true);
    }

    public JSONEventLayoutV0(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public String doLayout(ILoggingEvent loggingEvent) {
        this.fields = new HashMap();
        this.exception = new HashMap();
        this.event = new EventFormatter(loggingEvent);
        this.logstashEvent = new JSONObject();
        if (this.event.hasExceptionInfo()) {
            this.exception.put("stacktrace", this.event.getStackTrace());
            this.exception.put("exception_class", this.event.getExceptionClass());
            this.exception.put("exception_message", this.event.getExceptionMessage());
            this.addField("exception", this.exception);
        }
        this.addField("file", this.event.getFileName());
        this.addField("line_number", this.event.getLineNumber());
        this.addField("class", this.event.getClassName());
        this.addField("method", this.event.getMethodName());
        this.addField("loggerName", this.event.getLoggerName());
        this.addField("threadName", this.event.getThreadName());
        this.addField("level", this.event.getLevel());
        this.addField("mdc", this.event.getMDC());
        this.logstashEvent.put((Object)"@timestamp", (Object)this.event.getTimeStamp());
        this.logstashEvent.put((Object)"@source_host", (Object)this.event.getSourceHost());
        this.logstashEvent.put((Object)"@message", (Object)this.event.getMessage());
        this.logstashEvent.put((Object)"@fields", this.fields);
        return this.logstashEvent.toString() + "\n";
    }

    private void addField(String keyname, Object keyval) {
        if (null != keyval) {
            this.fields.put(keyname, keyval);
        }
    }
}

