/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.LayoutBase;
import java.util.HashMap;
import net.logstash.logback.EventFormatter;
import net.minidev.json.JSONObject;

public class JSONEventLayoutV1
extends LayoutBase<ILoggingEvent> {
    private String userFields;
    private boolean locationInfo;
    private static final Integer version = 1;
    public static String ADDITIONAL_DATA_PROPERTY = "net.logstash.logback.JSONEventLayoutV1.UserFields";
    private HashMap<String, Object> exception;
    private EventFormatter event;
    private JSONObject logstashEvent;

    public JSONEventLayoutV1() {
        this(true);
    }

    public JSONEventLayoutV1(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public String doLayout(ILoggingEvent loggingEvent) {
        String additionalUserFields;
        this.exception = new HashMap();
        this.event = new EventFormatter(loggingEvent);
        this.logstashEvent = new JSONObject();
        if (this.event.hasExceptionInfo()) {
            this.exception.put("stacktrace", this.event.getStackTrace());
            this.exception.put("exception_class", this.event.getExceptionClass());
            this.exception.put("exception_message", this.event.getExceptionMessage());
            this.logstashEvent.put((Object)"exception", this.exception);
        }
        this.logstashEvent.put((Object)"file", (Object)this.event.getFileName());
        this.logstashEvent.put((Object)"line_number", (Object)this.event.getLineNumber());
        this.logstashEvent.put((Object)"class", (Object)this.event.getClassName());
        this.logstashEvent.put((Object)"method", (Object)this.event.getMethodName());
        this.logstashEvent.put((Object)"logger_name", (Object)this.event.getLoggerName());
        this.logstashEvent.put((Object)"thread_name", (Object)this.event.getThreadName());
        this.logstashEvent.put((Object)"level", (Object)this.event.getLevel());
        this.logstashEvent.put((Object)"mdc", this.event.getMDC());
        this.logstashEvent.put((Object)"@timestamp", (Object)this.event.getTimeStamp());
        this.logstashEvent.put((Object)"@version", (Object)version);
        this.logstashEvent.put((Object)"source_host", (Object)this.event.getSourceHost());
        this.logstashEvent.put((Object)"message", (Object)this.event.getMessage());
        if (this.userFields != null) {
            this.addUserFields(this.userFields);
        }
        if ((additionalUserFields = System.getProperty(ADDITIONAL_DATA_PROPERTY)) != null) {
            this.addUserFields(additionalUserFields);
        }
        return this.logstashEvent.toString() + "\n";
    }

    public String getUserFields() {
        return this.userFields;
    }

    public void setUserFields(String userFields) {
        this.userFields = userFields;
    }

    private void addUserFields(String data) {
        if (null != data) {
            String[] pairs;
            for (String pair : pairs = data.split(",")) {
                String[] userField = pair.split(":", 2);
                if (userField[0] == null) continue;
                String key = userField[0];
                String val = userField[1];
                this.logstashEvent.put((Object)key, (Object)val);
            }
        }
    }
}

