/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.comp.CompilerOptionsProvider;
import org.snt.inmemantlr.comp.CunitProvider;
import org.snt.inmemantlr.comp.DefaultCompilerOptionsProvider;
import org.snt.inmemantlr.comp.FileProvider;
import org.snt.inmemantlr.comp.StringCodeGenPipeline;
import org.snt.inmemantlr.comp.StringCompiler;
import org.snt.inmemantlr.exceptions.CompilationException;
import org.snt.inmemantlr.exceptions.DeserializationException;
import org.snt.inmemantlr.exceptions.IllegalWorkflowException;
import org.snt.inmemantlr.exceptions.ParsingException;
import org.snt.inmemantlr.exceptions.RedundantCompilationException;
import org.snt.inmemantlr.exceptions.SerializationException;
import org.snt.inmemantlr.listener.DefaultListener;
import org.snt.inmemantlr.memobjects.GenericParserSerialize;
import org.snt.inmemantlr.memobjects.MemorySource;
import org.snt.inmemantlr.memobjects.MemoryTuple;
import org.snt.inmemantlr.memobjects.MemoryTupleSet;
import org.snt.inmemantlr.stream.DefaultStreamProvider;
import org.snt.inmemantlr.stream.StreamProvider;
import org.snt.inmemantlr.tool.InmemantlrErrorListener;
import org.snt.inmemantlr.tool.InmemantlrTool;
import org.snt.inmemantlr.tool.ToolCustomizer;
import org.snt.inmemantlr.utils.FileUtils;
import org.snt.inmemantlr.utils.Tuple;

public class GenericParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericParser.class);
    private InmemantlrTool antlr = new InmemantlrTool();
    private DefaultListener listener = new DefaultListener();
    private StringCompiler sc = new StringCompiler();
    private CompilerOptionsProvider oprov = new DefaultCompilerOptionsProvider();
    private FileProvider fp = new FileProvider();
    private StreamProvider provider = new DefaultStreamProvider();
    private boolean useCached = true;
    private String lexerName = "";
    private String parserName = "";

    private void init(Set<String> gcontent, ToolCustomizer tlc) {
        if (tlc != null) {
            tlc.customize(this.antlr);
        }
        Set<GrammarRootAST> ast = this.antlr.sortGrammarByTokenVocab(gcontent);
        for (GrammarRootAST gast : ast) {
            LOGGER.debug("gast {}", (Object)gast.getGrammarName());
            this.antlr.createPipeline(gast);
        }
    }

    private GenericParser(MemoryTupleSet mset, String parserName, String lexerName) {
        if (mset == null || mset.size() == 0) {
            throw new IllegalArgumentException("mset must not be null or empty");
        }
        this.sc.load(mset);
        LOGGER.debug("parser ", (Object)parserName);
        LOGGER.debug("parser ", (Object)lexerName);
        this.parserName = parserName;
        this.lexerName = lexerName;
    }

    public void addUtilityJavaFiles(File ... fils) throws FileNotFoundException {
        for (File f : fils) {
            this.addUtilityJavaFile(f);
        }
    }

    public void addUtilityJavaFiles(String ... fils) throws FileNotFoundException {
        for (String f : fils) {
            this.addUtilityJavaFile(new File(f));
        }
    }

    private void addUtilityJavaFile(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException("File " + f.getName() + " does not exist");
        }
        String name = FilenameUtils.removeExtension((String)f.getName());
        String content = FileUtils.loadFileContent(f);
        LOGGER.debug("add utility {}", (Object)name);
        this.fp.addFiles(new MemorySource(name, content));
    }

    public GenericParser(ToolCustomizer tlc, String ... gcontent) {
        this.init(new HashSet<String>(Arrays.asList(gcontent)), tlc);
    }

    public GenericParser(String ... gcontent) {
        this.init(new HashSet<String>(Arrays.asList(gcontent)), null);
    }

    public GenericParser(ToolCustomizer tlc, File ... gfile) throws FileNotFoundException {
        HashSet<String> gcontent = new HashSet<String>();
        for (File f : gfile) {
            if (!f.exists() || !f.canRead()) {
                throw new FileNotFoundException("file " + f.getAbsolutePath() + " does not exist or is not readable");
            }
            gcontent.add(FileUtils.loadFileContent(f.getAbsolutePath()));
        }
        this.init(gcontent, tlc);
    }

    public GenericParser(File ... gfile) throws FileNotFoundException {
        if (gfile.length == 0) {
            throw new IllegalArgumentException("Antlr grammar files must not be empty");
        }
        HashSet<String> gcontent = new HashSet<String>();
        for (File f : gfile) {
            if (!f.exists() || !f.canRead()) {
                throw new FileNotFoundException("file " + f.getAbsolutePath() + " does not exist or is not readable");
            }
            gcontent.add(FileUtils.loadFileContent(f.getAbsolutePath()));
        }
        this.init(gcontent, null);
    }

    public GenericParser(ToolCustomizer tlc, boolean useCached, String ... content) {
        this(tlc, content);
        this.useCached = useCached;
    }

    public static GenericParser instance(ToolCustomizer tlc, String content) {
        return new GenericParser(tlc, content);
    }

    public static GenericParser independentInstance(ToolCustomizer tlc, String content) {
        return new GenericParser(tlc, false, content);
    }

    public void setClassPath(Collection<String> cp) {
        this.oprov.setClassPath(cp);
    }

    public StreamProvider getStreamProvider() {
        return this.provider;
    }

    public void setStreamProvider(StreamProvider provider) {
        this.provider = provider;
    }

    public void setCompilerOptionsProvider(CompilerOptionsProvider oprov) {
        this.oprov = oprov;
    }

    public void compile() throws CompilationException {
        LOGGER.debug("compile");
        if (this.antrlObjectsAvailable()) {
            throw new RedundantCompilationException("Antlr objects are already available");
        }
        Set<StringCodeGenPipeline> pip = this.antlr.getPipelines();
        if (pip.isEmpty()) {
            throw new CompilationException("No string code pipeline available");
        }
        for (StringCodeGenPipeline p : pip) {
            for (MemorySource ms : p.getItems()) {
                LOGGER.debug(ms.getName() + " " + ms.toString());
            }
        }
        Tuple<String, String> parserLexer = this.antlr.process();
        this.parserName = parserLexer.getFirst();
        this.lexerName = parserLexer.getSecond();
        if (this.lexerName.isEmpty()) {
            throw new IllegalArgumentException("lexerName must not be empty");
        }
        LinkedHashSet<CunitProvider> cu = new LinkedHashSet<CunitProvider>();
        if (this.fp.hasItems()) {
            cu.add(this.fp);
        }
        cu.addAll(this.antlr.getCompilationUnits());
        this.sc.compile(cu, this.oprov);
    }

    public ParserRuleContext parse(File toParse) throws IllegalWorkflowException, FileNotFoundException, ParsingException {
        return this.parse(toParse, null, CaseSensitiveType.NONE);
    }

    public ParserRuleContext parse(File toParse, CaseSensitiveType cs) throws IllegalWorkflowException, FileNotFoundException, ParsingException {
        return this.parse(toParse, null, cs);
    }

    public ParserRuleContext parse(File toParse, String production, CaseSensitiveType cs) throws IllegalWorkflowException, FileNotFoundException, ParsingException {
        if (!toParse.exists()) {
            throw new FileNotFoundException("could not find file " + toParse.getAbsolutePath());
        }
        return this.parse(FileUtils.loadFileContent(toParse.getAbsolutePath()), production, cs);
    }

    public ParserRuleContext parse(String toParse) throws IllegalWorkflowException, ParsingException {
        return this.parse(toParse, null, CaseSensitiveType.NONE);
    }

    public ParserRuleContext parse(String toParse, CaseSensitiveType cs) throws IllegalWorkflowException, ParsingException {
        return this.parse(toParse, null, cs);
    }

    public void writeAntlrAritfactsTo(String dest) {
        MemoryTupleSet ms = this.getAllCompiledObjects();
        for (MemoryTuple tup : ms) {
            MemorySource src = tup.getSource();
            try {
                FileUtils.writeStringToFile(src.getCharContent(false).toString(), Paths.get(dest, src.getClassName()).toString() + ".java");
            }
            catch (FileExistsException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    public List<Token> lex(String toParse) throws IllegalWorkflowException {
        if (this.lexerName.isEmpty()) {
            throw new IllegalWorkflowException("lexerName must not be empty -- did you already run compile?");
        }
        InmemantlrErrorListener el = new InmemantlrErrorListener();
        this.listener.reset();
        CharStream input = this.provider.getCharStream(toParse);
        Objects.requireNonNull(input, "char stream must not be null");
        LOGGER.debug("load lexer {}", (Object)this.lexerName);
        Lexer lex = this.sc.instanciateLexer(input, this.lexerName, this.useCached);
        lex.addErrorListener((ANTLRErrorListener)el);
        Objects.requireNonNull(lex, "lex must not be null");
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        tokens.fill();
        return tokens.getTokens();
    }

    public ParserRuleContext parse(String toParse, String production, CaseSensitiveType cs) throws IllegalWorkflowException, ParsingException {
        String entryPoint;
        if (!this.antrlObjectsAvailable()) {
            throw new IllegalWorkflowException("No antlr objects have been compiled or loaded");
        }
        if (this.lexerName.isEmpty()) {
            throw new IllegalWorkflowException("lexerName must not be empty -- did you already run compile?");
        }
        if (this.parserName.isEmpty()) {
            throw new IllegalWorkflowException("parserName must not be empty -- run lex() in case you would like to run the lexer only.");
        }
        switch (cs) {
            case NONE: {
                break;
            }
            case UPPER: {
                toParse = toParse.toUpperCase();
                break;
            }
            case LOWER: {
                toParse = toParse.toLowerCase();
            }
        }
        InmemantlrErrorListener el = new InmemantlrErrorListener();
        this.listener.reset();
        CharStream input = this.provider.getCharStream(toParse);
        Objects.requireNonNull(input, "char stream must not be null");
        LOGGER.debug("load lexer {}", (Object)this.lexerName);
        Lexer lex = this.sc.instanciateLexer(input, this.lexerName, this.useCached);
        lex.addErrorListener((ANTLRErrorListener)el);
        Objects.requireNonNull(lex, "lex must not be null");
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        tokens.fill();
        LOGGER.debug("load parser {}", (Object)this.parserName);
        Parser parser = this.sc.instanciateParser(tokens, this.parserName);
        Objects.requireNonNull(parser, "Parser must not be null");
        this.listener.setParser(parser);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)el);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
        parser.setBuildParseTree(true);
        parser.setTokenStream((TokenStream)tokens);
        String[] rules = parser.getRuleNames();
        if (production == null) {
            entryPoint = rules[0];
        } else {
            if (!Arrays.asList(rules).contains(production)) {
                throw new IllegalArgumentException("Rule " + production + " not found");
            }
            entryPoint = production;
        }
        ParserRuleContext data = null;
        try {
            Class<?> pc = parser.getClass();
            Method m = pc.getDeclaredMethod(entryPoint, null);
            Objects.requireNonNull(m, "method should not be null");
            data = (ParserRuleContext)m.invoke((Object)parser, (Object[])null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
            return null;
        }
        Set msgs = el.getLog().entrySet().stream().filter(e -> e.getKey() == InmemantlrErrorListener.Type.SYNTAX_ERROR).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (!msgs.isEmpty()) {
            throw new ParsingException(String.join((CharSequence)"", msgs));
        }
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)this.listener, (ParseTree)data);
        return data;
    }

    public ParseTreeListener getListener() {
        return this.listener;
    }

    public void setListener(DefaultListener listener) {
        this.listener = listener;
    }

    public MemoryTupleSet getAllCompiledObjects() {
        return this.sc.getAllCompiledObjects();
    }

    public boolean antrlObjectsAvailable() {
        return this.getAllCompiledObjects().size() > 0;
    }

    public void store(String file, boolean overwrite) throws SerializationException {
        File loc = new File(file);
        File path = loc.getParentFile();
        LOGGER.debug("store file {}", (Object)loc.getAbsolutePath());
        if (loc.exists() && !overwrite) {
            throw new SerializationException("File " + file + " already exists");
        }
        if (!path.exists()) {
            throw new SerializationException("Cannot find path " + path.getAbsolutePath());
        }
        if (!this.antrlObjectsAvailable()) {
            throw new SerializationException("You have not compiled your grammar yet - there are no antlr objects available");
        }
        try (FileOutputStream fOut = new FileOutputStream(file);
             ObjectOutputStream oOut = new ObjectOutputStream(fOut);){
            GenericParserSerialize towrite = new GenericParserSerialize(this.getAllCompiledObjects(), this.parserName, this.lexerName);
            oOut.writeObject(towrite);
        }
        catch (NotSerializableException e) {
            LOGGER.error("Not serializable:", (Object)e.getMessage());
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Output file cannot be found: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            LOGGER.error("IO Error: {}", (Object)e.getMessage());
        }
    }

    public String getLexerName() {
        return this.lexerName;
    }

    public void setLexerName(String lexerName) {
        this.lexerName = lexerName;
    }

    public String getParserName() {
        return this.parserName;
    }

    public void setParserName(String parserName) {
        this.parserName = parserName;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static GenericParser load(String file) throws DeserializationException {
        File loc = new File(file);
        File path = loc.getParentFile();
        if (!path.exists()) {
            throw new DeserializationException("Cannot find path " + path.getAbsolutePath());
        }
        if (!loc.exists()) {
            throw new DeserializationException("File " + file + " does not exist");
        }
        LOGGER.debug("load file {}", (Object)loc.getAbsolutePath());
        try (FileInputStream f_in = new FileInputStream(file);){
            GenericParser genericParser;
            try (ObjectInputStream o_in = new ObjectInputStream(f_in);){
                Object toread = o_in.readObject();
                if (!(toread instanceof GenericParserSerialize)) {
                    throw new IllegalArgumentException("toread must be an instance of GenericParserSerialize");
                }
                GenericParserSerialize gin = (GenericParserSerialize)toread;
                GenericParser gp = new GenericParser(gin.getMemoryTupleSet(), gin.getParserName(), gin.getLexerName());
                if (!gp.antrlObjectsAvailable()) {
                    throw new DeserializationException("there are no antlr objects available in " + file);
                }
                genericParser = gp;
            }
            return genericParser;
        }
        catch (FileNotFoundException e) {
            throw new DeserializationException(String.format("Problem loading %s", file), e);
        }
        catch (NotSerializableException e) {
            throw new DeserializationException("cannot read object", e);
        }
        catch (ClassNotFoundException e) {
            throw new DeserializationException("cannot find class", e);
        }
        catch (IOException e) {
            throw new DeserializationException(e.getMessage(), e);
        }
    }

    public static enum CaseSensitiveType {
        NONE,
        UPPER,
        LOWER;

    }
}

