/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr;

import java.io.File;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.GenericParser;
import org.snt.inmemantlr.exceptions.CompilationException;
import org.snt.inmemantlr.exceptions.IllegalWorkflowException;
import org.snt.inmemantlr.exceptions.ParsingException;
import org.snt.inmemantlr.listener.DefaultTreeListener;
import org.snt.inmemantlr.tree.ParseTree;

public class GenericParserToGo {
    private GenericParser gp;
    private DefaultTreeListener dl;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericParserToGo.class);

    public GenericParserToGo(String ... grammar) {
        this.gp = new GenericParser(grammar);
        try {
            this.gp.compile();
        }
        catch (CompilationException e) {
            LOGGER.error(e.getMessage());
            System.exit(-1);
        }
        this.dl = new DefaultTreeListener(true);
        this.gp.setListener(this.dl);
    }

    public GenericParserToGo(File ... grammar) {
        try {
            this.gp = new GenericParser(grammar);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
            System.exit(-1);
        }
        try {
            this.gp.compile();
        }
        catch (CompilationException e) {
            LOGGER.error(e.getMessage());
            System.exit(-1);
        }
        this.dl = new DefaultTreeListener(true);
        this.gp.setListener(this.dl);
    }

    public ParseTree parse(String s, String rule) {
        try {
            this.gp.parse(s, rule, GenericParser.CaseSensitiveType.NONE);
            return this.dl.getParseTree();
        }
        catch (IllegalWorkflowException e) {
            LOGGER.error(e.getMessage());
            System.exit(-1);
        }
        catch (ParsingException e) {
            LOGGER.error(e.getMessage());
        }
        return null;
    }

    public ParseTree parse(File f, String rule) {
        try {
            this.gp.parse(f, rule, GenericParser.CaseSensitiveType.NONE);
            return this.dl.getParseTree();
        }
        catch (IllegalWorkflowException e) {
            LOGGER.error(e.getMessage());
            System.exit(-1);
        }
        catch (ParsingException e) {
            LOGGER.error(e.getMessage());
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
            System.exit(-1);
        }
        return null;
    }
}

