/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.comp;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.memobjects.MemoryByteCode;

class SpecialClassLoader
extends ClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecialClassLoader.class);
    private Map<String, MemoryByteCode> m = new HashMap<String, MemoryByteCode>();

    public SpecialClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        MemoryByteCode mbc = this.m.get(name);
        if (mbc == null && (mbc = this.m.get(name.replace(".", "/"))) == null) {
            LOGGER.error("Could not find {}", (Object)name);
            return super.findClass(name);
        }
        byte[] bseq = mbc.getBytes();
        return this.defineClass(name, bseq, 0, bseq.length);
    }

    public void addClass(MemoryByteCode mbc) {
        this.m.put(mbc.getClassName(), mbc);
    }
}

