/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.comp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.snt.inmemantlr.comp.SpecialClassLoader;
import org.snt.inmemantlr.memobjects.MemoryByteCode;

class SpecialJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private SpecialClassLoader xcl;
    private HashMap<String, MemoryByteCode> mb = new HashMap();

    public SpecialJavaFileManager(StandardJavaFileManager sjfm, SpecialClassLoader xcl) {
        super(sjfm);
        this.xcl = xcl;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        MemoryByteCode mbc = new MemoryByteCode(name);
        this.mb.put(mbc.getClassName(), mbc);
        this.xcl.addClass(mbc);
        return mbc;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.xcl;
    }

    public Set<MemoryByteCode> getByteCodeFromClass(String cname) {
        Set<MemoryByteCode> ret = this.mb.values().stream().filter(m -> m.getClassName().matches("(([a-zA-Z_0-9\\.]+)/?)*" + cname + "(\\$.*)?")).collect(Collectors.toSet());
        if (ret.isEmpty()) {
            throw new IllegalArgumentException("bytecode of class " + cname + " is empty");
        }
        return ret;
    }
}

