/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.comp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.codegen.CodeGenPipeline;
import org.antlr.v4.codegen.CodeGenerator;
import org.antlr.v4.codegen.model.BaseListenerFile;
import org.antlr.v4.codegen.model.BaseVisitorFile;
import org.antlr.v4.codegen.model.LexerFile;
import org.antlr.v4.codegen.model.ListenerFile;
import org.antlr.v4.codegen.model.OutputFile;
import org.antlr.v4.codegen.model.ParserFile;
import org.antlr.v4.codegen.model.VisitorFile;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.LexerGrammar;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.comp.CunitProvider;
import org.snt.inmemantlr.grammar.InmemantlrGrammar;
import org.snt.inmemantlr.memobjects.MemorySource;
import org.stringtemplate.v4.ST;

public class StringCodeGenPipeline
extends CodeGenPipeline
implements CunitProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringCodeGenPipeline.class);
    private Grammar g;
    private String name;
    private ST parser;
    private ST lexer;
    private ST visitor;
    private ST listener;
    private ST baseListener;
    private ST baseVisitor;
    private ST tokenvocab;

    public StringCodeGenPipeline(Grammar g) {
        super(g);
        this.g = g;
        this.name = g.name;
        this.lexer = null;
        this.listener = null;
        this.visitor = null;
        this.baseListener = null;
        this.baseVisitor = null;
    }

    public boolean hasParser() {
        return this.parser != null;
    }

    public ST getParser() {
        return this.parser;
    }

    public ST getBaseListener() {
        return this.baseListener;
    }

    public boolean hasBaseListener() {
        return this.baseListener != null;
    }

    public ST getLexer() {
        return this.lexer;
    }

    public boolean hasLexer() {
        return this.lexer != null;
    }

    public ST getVisitor() {
        return this.visitor;
    }

    public boolean hasVisitor() {
        return this.visitor != null;
    }

    public ST getListener() {
        return this.listener;
    }

    public boolean hasListener() {
        return this.listener != null;
    }

    public ST getBaseVisitor() {
        return this.baseVisitor;
    }

    public ST getTokenVocab() {
        return this.tokenvocab;
    }

    public boolean hasBaseVisitor() {
        return this.baseVisitor != null;
    }

    public boolean hasTokenVocab() {
        return this.tokenvocab != null;
    }

    public Grammar getG() {
        return this.g;
    }

    public void setG(InmemantlrGrammar g) {
        this.g = g;
    }

    public void process() {
        CodeGenerator cgen = new CodeGenerator(this.g);
        IntervalSet idTypes = new IntervalSet(new int[0]);
        idTypes.add(28);
        idTypes.add(57);
        idTypes.add(66);
        List idNodes = this.g.ast.getNodesWithType(idTypes);
        idNodes.stream().filter(idNode -> cgen.getTarget().grammarSymbolCausesIssueInGeneratedCode(idNode)).forEach(idNode -> this.g.tool.errMgr.grammarError(ErrorType.USE_OF_BAD_WORD, this.g.fileName, idNode.getToken(), new Object[]{idNode.getText()}));
        if (this.g.isLexer()) {
            this.lexer = cgen.generateLexer();
        } else {
            LexerGrammar lg;
            this.parser = cgen.generateParser();
            if (this.g.tool.gen_listener) {
                this.listener = cgen.generateListener();
                if (cgen.getTarget().wantsBaseListener()) {
                    this.baseListener = cgen.generateBaseListener();
                }
            }
            if (this.g.tool.gen_visitor) {
                this.visitor = cgen.generateVisitor();
                if (cgen.getTarget().wantsBaseVisitor()) {
                    this.baseVisitor = cgen.generateBaseVisitor();
                }
            }
            if ((lg = this.g.implicitLexer) != null) {
                CodeGenerator lgcg = new CodeGenerator((Grammar)lg);
                this.lexer = lgcg.generateLexer();
            }
        }
        this.tokenvocab = this.getTokenVocabOutput();
    }

    ST getTokenVocabOutput() {
        ST vocabFileST = new ST("<tokens.keys:{t | <t>=<tokens.(t)>\n}><literals.keys:{t | <t>=<literals.(t)>\n}>");
        LinkedHashMap<String, Integer> tokens = new LinkedHashMap<String, Integer>();
        for (String t : this.g.tokenNameToTypeMap.keySet()) {
            int tokenType = (Integer)this.g.tokenNameToTypeMap.get(t);
            if (tokenType < 1) continue;
            tokens.put(t, tokenType);
        }
        vocabFileST.add("tokenvocab", tokens);
        LinkedHashMap<String, Integer> literals = new LinkedHashMap<String, Integer>();
        for (String literal : this.g.stringLiteralToTypeMap.keySet()) {
            int tokenType = (Integer)this.g.stringLiteralToTypeMap.get(literal);
            if (tokenType < 1) continue;
            literals.put(literal, tokenType);
        }
        vocabFileST.add("literals", literals);
        return vocabFileST;
    }

    public String getParserName() {
        ParserFile f = (ParserFile)this.parser.getAttributes().get("file");
        LOGGER.debug("parser name {}", (Object)this.modFile((OutputFile)f));
        return this.modFile((OutputFile)f);
    }

    public String getLexerName() {
        LexerFile f = (LexerFile)this.lexer.getAttributes().get("lexerFile");
        LOGGER.debug("lexer name {}", (Object)this.modFile((OutputFile)f));
        return this.modFile((OutputFile)f);
    }

    public String getVisitorName() {
        VisitorFile f = (VisitorFile)this.visitor.getAttributes().get("file");
        LOGGER.debug("listener name {}", (Object)this.modFile((OutputFile)f));
        return this.modFile((OutputFile)f);
    }

    public String getBaseVisitorName() {
        BaseVisitorFile f = (BaseVisitorFile)this.baseVisitor.getAttributes().get("file");
        LOGGER.debug("listener name {}", (Object)this.modFile((OutputFile)f));
        return this.modFile((OutputFile)f);
    }

    public String getListenerName() {
        ListenerFile f = (ListenerFile)this.listener.getAttributes().get("file");
        LOGGER.debug("listener name {}", (Object)this.modFile((OutputFile)f));
        return this.modFile((OutputFile)f);
    }

    public String getBaseListenerName() {
        BaseListenerFile f = (BaseListenerFile)this.baseListener.getAttributes().get("file");
        LOGGER.debug("base listener name {}", (Object)this.modFile((OutputFile)f));
        return this.modFile((OutputFile)f);
    }

    public String getTokenVocabFileName() {
        return this.g.name + ".tokens";
    }

    public String getTokenVocabString() {
        Map vocab = (Map)this.tokenvocab.getAttribute("tokenvocab");
        Map lit = (Map)this.tokenvocab.getAttribute("literals");
        StringBuilder sb = new StringBuilder();
        vocab.forEach((s, i) -> sb.append((String)s).append("=").append(i.toString()).append("\n"));
        lit.forEach((s, i) -> sb.append((String)s).append("=").append(i.toString()).append("\n"));
        return sb.toString();
    }

    private String modFile(OutputFile f) {
        return FilenameUtils.removeExtension((String)f.fileName);
    }

    @Override
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof StringCodeGenPipeline && this.name.equals(((StringCodeGenPipeline)o).name);
    }

    @Override
    public Collection<MemorySource> getItems() {
        ArrayList<MemorySource> ret = new ArrayList<MemorySource>();
        if (this.hasLexer()) {
            ret.add(new MemorySource(this.getLexerName(), this.lexer.render()));
        }
        if (this.hasBaseListener()) {
            ret.add(new MemorySource(this.getBaseListenerName(), this.baseListener.render()));
        }
        if (this.hasBaseVisitor()) {
            ret.add(new MemorySource(this.getBaseVisitorName(), this.baseVisitor.render()));
        }
        if (this.hasParser()) {
            ret.add(new MemorySource(this.getParserName(), this.parser.render()));
        }
        if (this.hasListener()) {
            ret.add(new MemorySource(this.getListenerName(), this.listener.render()));
        }
        if (this.hasVisitor()) {
            ret.add(new MemorySource(this.getVisitorName(), this.visitor.render()));
        }
        return ret;
    }

    @Override
    public boolean hasItems() {
        return !this.getItems().isEmpty();
    }
}

