/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.comp;

import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.comp.CompilerOptionsProvider;
import org.snt.inmemantlr.comp.CunitProvider;
import org.snt.inmemantlr.comp.SpecialClassLoader;
import org.snt.inmemantlr.comp.SpecialJavaFileManager;
import org.snt.inmemantlr.exceptions.CompilationErrorException;
import org.snt.inmemantlr.memobjects.MemoryByteCode;
import org.snt.inmemantlr.memobjects.MemorySource;
import org.snt.inmemantlr.memobjects.MemoryTuple;
import org.snt.inmemantlr.memobjects.MemoryTupleSet;

public class StringCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringCompiler.class);
    private static final String CONSTRUCTOR_ARG = "interface org.antlr.v4.runtime.TokenStream";
    private SpecialClassLoader cl = null;
    private MemoryTupleSet mt = null;
    private Map<String, Lexer> lexer = null;
    private Map<String, Parser> parser = null;
    private Map<String, Class<?>> classes = new HashMap();
    private static final Class<?>[] parameters = new Class[]{URL.class};

    public StringCompiler() {
        this.cl = new SpecialClassLoader(this.getClass().getClassLoader());
        this.lexer = new HashMap<String, Lexer>();
        this.parser = new HashMap<String, Parser>();
        this.mt = new MemoryTupleSet();
    }

    public void load(MemoryTupleSet mset) {
        if (mset == null || mset.size() == 0) {
            throw new IllegalArgumentException("mset must not be null or empty");
        }
        this.mt.addAll(mset);
        mset.forEach((Consumer<? super MemoryTuple>)((Consumer<MemoryTuple>)tup -> tup.getByteCodeObjects().forEach(bc -> this.cl.addClass((MemoryByteCode)bc))));
    }

    public void compile(Set<CunitProvider> units, CompilerOptionsProvider oprov) throws CompilationErrorException {
        boolean failedCompilation;
        JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager sjfm = javac.getStandardFileManager(null, null, null);
        SpecialJavaFileManager fileManager = new SpecialJavaFileManager(sjfm, this.cl);
        ArrayList<MemorySource> cunit = new ArrayList<MemorySource>();
        HashSet<MemorySource> mset = new HashSet<MemorySource>();
        for (CunitProvider sc : units) {
            cunit.addAll(sc.getItems());
            for (MemorySource ms : sc.getItems()) {
                LOGGER.debug(ms.toString());
            }
        }
        mset.addAll(cunit);
        DiagnosticListener<? super JavaFileObject> dlistener = null;
        Iterable<String> classes = null;
        StringWriter out = new StringWriter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.addAll(oprov.getOptions());
        JavaCompiler.CompilationTask compile = javac.getTask(out, fileManager, dlistener, optionList, classes, cunit);
        boolean bl = failedCompilation = compile.call() == false;
        if (failedCompilation) {
            throw new CompilationErrorException(((Object)out).toString());
        }
        for (MemorySource ms : mset) {
            Set<MemoryByteCode> mb = fileManager.getByteCodeFromClass(ms.getClassName());
            if (mb.isEmpty()) {
                throw new IllegalArgumentException("MemoryByteCode must not be empty");
            }
            this.mt.addMemoryTuple(ms, mb);
        }
    }

    private Class<?> findClass(String cname) {
        Class<?> clazz;
        try {
            if (this.classes.containsKey(cname)) {
                clazz = this.classes.get(cname);
            } else {
                clazz = this.cl.findClass(cname);
                this.classes.put(cname, clazz);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return clazz;
    }

    public Lexer instanciateLexer(CharStream input, String lexerClassName, boolean useCached) {
        Lexer elexer;
        if (useCached && this.lexer.containsKey(lexerClassName)) {
            Lexer elexer2 = this.lexer.get(lexerClassName);
            elexer2.reset();
            elexer2.setInputStream((IntStream)input);
            return elexer2;
        }
        Class<?> elex = this.findClass(lexerClassName);
        if (elex == null) {
            return null;
        }
        Constructor<?>[] cstr = elex.getConstructors();
        if (cstr.length != 1) {
            throw new IllegalArgumentException("There must be only constructor");
        }
        try {
            elexer = (Lexer)cstr[0].newInstance(input);
            this.lexer.put(lexerClassName, elexer);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            return null;
        }
        return elexer;
    }

    public Parser instanciateParser(CommonTokenStream tstream, String parserClassName) {
        Parser eparser;
        Class<?> elex = this.findClass(parserClassName);
        Objects.requireNonNull(elex, "Failed to find class " + parserClassName);
        Constructor<?>[] cstr = elex.getConstructors();
        if (cstr.length == 0) {
            throw new IllegalArgumentException("Constructors must not be empty");
        }
        int cidx = 0;
        for (Constructor<?> c : cstr) {
            LOGGER.debug(c.getParameters()[0].getType().toString());
            if (c.getParameterCount() == 1 && c.getParameters()[0].getType().toString().equals(CONSTRUCTOR_ARG)) break;
            ++cidx;
        }
        try {
            eparser = (Parser)cstr[cidx].newInstance(tstream);
            this.parser.put(parserClassName, eparser);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
        return eparser;
    }

    public MemoryTupleSet getAllCompiledObjects() {
        return this.mt;
    }
}

