/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.grammar;

import java.util.Map;
import org.antlr.v4.Tool;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.tool.MemoryTokenVocabParser;

public class InmemantlrGrammar
extends Grammar {
    private static final Logger LOGGER = LoggerFactory.getLogger(InmemantlrGrammar.class);
    private String tokenVocab = "";

    public InmemantlrGrammar(Tool tool, GrammarRootAST ast) {
        super(tool, ast);
    }

    public void setTokenVocab(String tokenVocab) {
        this.tokenVocab = tokenVocab;
    }

    public void importTokensFromTokensFile() {
        if (!this.tokenVocab.isEmpty()) {
            MemoryTokenVocabParser vparser = new MemoryTokenVocabParser(this, this.tokenVocab);
            Map<String, Integer> tokens = vparser.load();
            for (String t : tokens.keySet()) {
                int ret = t.charAt(0) == '\'' ? this.defineStringLiteral(t, tokens.get(t)) : this.defineTokenName(t, tokens.get(t));
                if (ret == 0) {
                    throw new IllegalArgumentException("Token must not be INVALID_TYPE");
                }
                LOGGER.debug("token {} {}", (Object)t, (Object)tokens.get(t));
            }
        }
    }
}

