/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.grammar;

import java.util.Map;
import org.antlr.v4.Tool;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.LexerGrammar;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.tool.MemoryTokenVocabParser;

public class InmemantlrLexerGrammar
extends LexerGrammar {
    private static final Logger LOGGER = LoggerFactory.getLogger(InmemantlrLexerGrammar.class);
    private String tokenVocab = "";

    public InmemantlrLexerGrammar(Tool tool, GrammarRootAST ast) {
        super(tool, ast);
    }

    public void setTokenVocab(String tokenVocab) {
        LOGGER.debug("set token vocab {} {}", (Object)this.name, (Object)tokenVocab);
        this.tokenVocab = tokenVocab;
    }

    public void importTokensFromTokensFile() {
        LOGGER.debug("import tokens from file");
        if (!this.tokenVocab.isEmpty()) {
            MemoryTokenVocabParser vparser = new MemoryTokenVocabParser((Grammar)this, this.tokenVocab);
            Map<String, Integer> tokens = vparser.load();
            for (String t : tokens.keySet()) {
                if (t.charAt(0) == '\'') {
                    this.defineStringLiteral(t, tokens.get(t));
                    continue;
                }
                this.defineTokenName(t, tokens.get(t));
            }
        } else {
            LOGGER.debug("token vocab empty");
        }
    }
}

