/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.listener;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.listener.DefaultListener;
import org.snt.inmemantlr.tree.ParseTree;
import org.snt.inmemantlr.tree.ParseTreeNode;

public class DefaultTreeListener
extends DefaultListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTreeListener.class);
    private static final long serialVersionUID = 5637734678821255670L;
    protected Deque<String> sctx = new ArrayDeque<String>();
    protected StringBuilder glob = new StringBuilder();
    protected ParseTree parseTree = null;
    protected ParseTreeNode nodeptr = null;
    protected Predicate<String> filter = null;
    protected boolean includeTerminals = false;

    public DefaultTreeListener() {
        this(false);
    }

    public DefaultTreeListener(boolean includeTerminals) {
        this(x -> !x.isEmpty());
        this.includeTerminals = includeTerminals;
    }

    public DefaultTreeListener(Predicate<String> filter) {
        this.sctx.add("S");
        this.parseTree = new ParseTree("root", "root");
        this.nodeptr = this.parseTree.getRoot();
        this.filter = filter;
    }

    @Override
    public void visitTerminal(TerminalNode terminalNode) {
        if (this.includeTerminals) {
            Token token = terminalNode.getSymbol();
            ParseTreeNode n = this.parseTree.newNode(this.nodeptr, "", terminalNode.toString(), token.getStartIndex(), token.getStopIndex(), token.getLine(), token.getCharPositionInLine());
            this.nodeptr.addChild(n);
        }
    }

    @Override
    public void visitErrorNode(ErrorNode errorNode) {
    }

    @Override
    public void enterEveryRule(ParserRuleContext ctx) {
        String rule = this.getRuleByKey(ctx.getRuleIndex());
        if (this.filter.test(rule)) {
            Token s = ctx.getStart();
            Token e = ctx.getStop();
            ParseTreeNode n = this.parseTree.newNode(this.nodeptr, rule, ctx.getText(), s != null ? s.getStartIndex() : 0, e != null ? e.getStopIndex() : 0, s != null ? s.getLine() : 0, s != null ? s.getCharPositionInLine() : 0);
            this.nodeptr.addChild(n);
            this.nodeptr = n;
        }
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
        String rule = this.getRuleByKey(ctx.getRuleIndex());
        if (this.filter.test(rule)) {
            this.nodeptr = this.nodeptr.getParent();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.sctx.clear();
        this.sctx.add("S");
        this.parseTree = new ParseTree("root", "root");
        this.nodeptr = this.parseTree.getRoot();
        this.glob.delete(0, this.glob.length());
    }

    public ParseTree getParseTree() {
        return this.parseTree;
    }

    public Set<ParseTreeNode> getNodes() {
        return new HashSet<ParseTreeNode>(this.parseTree.getNodes());
    }

    public String toString() {
        return this.glob.toString();
    }
}

