/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.memobjects;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import javax.tools.JavaFileObject;
import org.snt.inmemantlr.memobjects.MemoryFile;

public class MemoryByteCode
extends MemoryFile
implements Serializable {
    private static final long serialVersionUID = 2268365481259432191L;
    private transient ByteArrayOutputStream baos;
    private final String cname;
    private byte[] bytebuf = null;

    public MemoryByteCode(String name) {
        super(URI.create("byte:///" + name + ".class"), JavaFileObject.Kind.CLASS);
        this.cname = name;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return new String(this.getBytes());
    }

    @Override
    public OutputStream openOutputStream() {
        this.baos = new ByteArrayOutputStream();
        return this.baos;
    }

    @Override
    public InputStream openInputStream() {
        throw new IllegalStateException();
    }

    public byte[] getBytes() {
        if (this.bytebuf == null) {
            this.bytebuf = this.baos.toByteArray();
        }
        return this.bytebuf;
    }

    public String getClassName() {
        return this.cname;
    }

    public boolean isInnerClass() {
        return this.cname.contains("$");
    }

    public int hashCode() {
        return this.cname.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MemoryByteCode)) {
            return false;
        }
        MemoryByteCode mb = (MemoryByteCode)o;
        return mb.cname.equals(this.cname);
    }
}

