/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.memobjects;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import javax.tools.JavaFileObject;
import org.snt.inmemantlr.memobjects.MemoryFile;

public class MemorySource
extends MemoryFile
implements Serializable {
    private static final long serialVersionUID = 898301300090559769L;
    private String src;
    private String cname;

    public MemorySource() {
    }

    public MemorySource(String name, String src) {
        super(URI.create("file:///" + name + ".java"), JavaFileObject.Kind.SOURCE);
        this.src = src;
        this.cname = name;
    }

    public String getClassName() {
        return this.cname;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.src;
    }

    @Override
    public OutputStream openOutputStream() {
        throw new IllegalStateException();
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.src.getBytes());
    }

    @Override
    public String toString() {
        return this.cname;
    }
}

