/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.memobjects;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.snt.inmemantlr.memobjects.MemoryByteCode;
import org.snt.inmemantlr.memobjects.MemorySource;

public class MemoryTuple
implements Serializable {
    private static final long serialVersionUID = 3586252835232647406L;
    private MemorySource source;
    private Set<MemoryByteCode> bytecodeObjects = new HashSet<MemoryByteCode>();
    private String cname;

    public MemoryTuple() {
    }

    public MemoryTuple(MemorySource source, Set<MemoryByteCode> bytecode) {
        this();
        if (bytecode == null || bytecode.isEmpty()) {
            throw new IllegalArgumentException("bytecode set must not be null or empty");
        }
        this.source = source;
        this.bytecodeObjects.addAll(bytecode);
        this.cname = source.getClassName();
    }

    public MemorySource getSource() {
        return this.source;
    }

    public Set<MemoryByteCode> getByteCodeObjects() {
        return this.bytecodeObjects;
    }

    public String getClassName() {
        return this.cname;
    }

    public int hashCode() {
        return this.cname.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MemoryTuple)) {
            return false;
        }
        MemoryTuple mo = (MemoryTuple)o;
        return mo.cname.equals(this.cname);
    }

    public boolean isParser() {
        return this.cname.endsWith("Parser");
    }

    public boolean isBaseListener() {
        return this.cname.endsWith("BaseListener");
    }

    public boolean isListener() {
        return this.cname.endsWith("Listener");
    }

    public boolean isLexer() {
        return this.cname.endsWith("Lexer");
    }
}

