/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.memobjects;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.memobjects.MemoryByteCode;
import org.snt.inmemantlr.memobjects.MemorySource;
import org.snt.inmemantlr.memobjects.MemoryTuple;

public class MemoryTupleSet
implements Serializable,
Iterable<MemoryTuple> {
    private static final long serialVersionUID = -1187957244085829285L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryTupleSet.class);
    private Set<MemoryTuple> mts = new HashSet<MemoryTuple>();

    public void addMemoryTuple(MemorySource source, Set<MemoryByteCode> bytecode) {
        LOGGER.debug("add tuple {}", (Object)source.getClassName());
        this.mts.add(new MemoryTuple(source, bytecode));
    }

    public int size() {
        return this.mts.size();
    }

    @Override
    public Iterator<MemoryTuple> iterator() {
        return this.mts.iterator();
    }

    @Override
    public void forEach(Consumer<? super MemoryTuple> action) {
        this.mts.forEach(action);
    }

    @Override
    public Spliterator<MemoryTuple> spliterator() {
        return this.mts.spliterator();
    }

    public void addAll(MemoryTupleSet mset) {
        this.mts.addAll(mset.mts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.mts.stream().forEach((? super T t) -> {
            MemorySource s = t.getSource();
            Set<MemoryByteCode> bs = t.getByteCodeObjects();
            sb.append(s.getClassName()).append(":\n");
            bs.forEach((? super T b) -> sb.append(b.getClassName()).append(" "));
            sb.append("\n");
        });
        return sb.toString();
    }
}

