/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.tool;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InmemantlrErrorListener
extends BaseErrorListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseErrorListener.class);
    Map<Type, String> log = new HashMap<Type, String>();

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        this.log.put(Type.SYNTAX_ERROR, "(line " + line + ",char " + charPositionInLine + "): " + msg);
    }

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        this.log.put(Type.AMBIGUITY, "Ambiguity " + startIndex + " " + stopIndex);
    }

    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        this.log.put(Type.FULL_CTX, "Attempting full Context " + startIndex + " " + stopIndex);
    }

    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        this.log.put(Type.CTX_SSTV, "Context Sensitivity " + startIndex + " " + stopIndex);
    }

    public Map<Type, String> getLog() {
        return this.log;
    }

    public static enum Type {
        SYNTAX_ERROR,
        AMBIGUITY,
        FULL_CTX,
        CTX_SSTV;

    }
}

