/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.Tool;
import org.antlr.v4.analysis.AnalysisPipeline;
import org.antlr.v4.automata.LexerATNFactory;
import org.antlr.v4.automata.ParserATNFactory;
import org.antlr.v4.codegen.CodeGenPipeline;
import org.antlr.v4.codegen.CodeGenerator;
import org.antlr.v4.misc.Graph;
import org.antlr.v4.semantics.SemanticPipeline;
import org.antlr.v4.tool.ANTLRMessage;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.GrammarTransformPipeline;
import org.antlr.v4.tool.LexerGrammar;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.GrammarASTErrorNode;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.comp.StringCodeGenPipeline;
import org.snt.inmemantlr.grammar.InmemantlrGrammar;
import org.snt.inmemantlr.grammar.InmemantlrLexerGrammar;
import org.snt.inmemantlr.utils.Tuple;

public class InmemantlrTool
extends Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(InmemantlrTool.class);
    private Map<String, StringCodeGenPipeline> pip = new HashMap<String, StringCodeGenPipeline>();
    private Map<String, GrammarRootAST> ast = new HashMap<String, GrammarRootAST>();
    private Map<String, String> tokvok = new HashMap<String, String>();
    private List<String> order = new ArrayList<String>();
    private Set<String> imported = new HashSet<String>();
    private String parserName = "";
    private String lexerName = "";

    public InmemantlrTool() {
        this.gen_dependencies = true;
    }

    public void process(Grammar g) {
        this.process(g, false);
    }

    public Grammar createGrammar(GrammarRootAST ast) {
        LOGGER.debug("ast " + ast.getGrammarName());
        Object g = ast.grammarType == 31 ? new InmemantlrLexerGrammar(this, ast) : new InmemantlrGrammar(this, ast);
        GrammarTransformPipeline.setGrammarPtr((Grammar)g, (GrammarAST)ast);
        return g;
    }

    public Set<GrammarRootAST> sortGrammarByTokenVocab(Set<String> gcs) {
        Graph g = new Graph();
        ArrayList<GrammarRootAST> roots = new ArrayList<GrammarRootAST>();
        for (String gc : gcs) {
            GrammarRootAST t = this.parseGrammarFromString(gc);
            if (t instanceof GrammarASTErrorNode || t.hasErrors) continue;
            GrammarRootAST root = t;
            roots.add(root);
            root.fileName = root.getGrammarName();
            String grammarName = root.getChild(0).getText();
            GrammarAST tokenVocabNode = InmemantlrTool.findOptionValueAST((GrammarRootAST)root, (String)"tokenVocab");
            if (tokenVocabNode != null) {
                String vocabName = tokenVocabNode.getText();
                g.addEdge((Object)grammarName, (Object)vocabName);
            }
            g.addEdge((Object)grammarName, (Object)grammarName);
        }
        List sortedGrammarNames = g.sort();
        LinkedHashSet<GrammarRootAST> sortedRoots = new LinkedHashSet<GrammarRootAST>();
        block1: for (String grammarName : sortedGrammarNames) {
            for (GrammarRootAST root : roots) {
                if (!root.getGrammarName().equals(grammarName)) continue;
                LOGGER.debug("add to ast buffer {}", (Object)grammarName);
                this.ast.put(grammarName, root);
                this.order.add(grammarName);
                sortedRoots.add(root);
                continue block1;
            }
        }
        return sortedRoots;
    }

    public Grammar loadImportedGrammar(Grammar g, GrammarAST nameNode) throws IOException {
        String name = nameNode.getText();
        this.imported.add(name);
        if (this.pip.containsKey(name)) {
            return this.pip.get(name).getG();
        }
        return null;
    }

    public String getPackagePrefix() {
        return this.genPackage != null && !this.genPackage.isEmpty() ? this.genPackage + "." : "";
    }

    public StringCodeGenPipeline createPipeline(GrammarRootAST ast) {
        if (this.pip.containsKey(ast.getGrammarName())) {
            this.pip.get(ast.getGrammarName());
        }
        LOGGER.debug("create grammar {}", (Object)ast.getGrammarName());
        Grammar g = this.createGrammar(ast);
        g.fileName = g.name;
        g.loadImportedGrammars();
        StringCodeGenPipeline spip = new StringCodeGenPipeline(g);
        LOGGER.debug("put grammar {}", (Object)g.name);
        this.pip.put(g.name, spip);
        return spip;
    }

    public Set<StringCodeGenPipeline> getPipelines() {
        return this.order.stream().filter(s -> this.pip.containsKey(s)).map(s -> this.pip.get(s)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean isImported(String name) {
        return this.imported.contains(name);
    }

    private void setParserLexer(Grammar g) {
        String pfx = this.getPackagePrefix();
        if (g.isParser()) {
            LOGGER.debug("parser {}", (Object)g.name);
            this.parserName = pfx + g.name;
        } else if (g.isLexer()) {
            LOGGER.debug("lexer {}", (Object)g.name);
            this.lexerName = pfx + g.name;
        } else {
            this.parserName = pfx + g.name + "Parser";
            this.lexerName = pfx + g.name + "Lexer";
        }
    }

    public Tuple<String, String> process() {
        LOGGER.debug("process grammars");
        Object last = null;
        Set<StringCodeGenPipeline> pip = this.getPipelines();
        if (pip.isEmpty()) {
            throw new IllegalArgumentException("pip must not be empty");
        }
        for (StringCodeGenPipeline p : pip) {
            Grammar g = p.getG();
            LOGGER.debug("process {}", (Object)g.name);
            String s = this.getDepTokVocName(g);
            if (s != null && !s.isEmpty() && this.tokvok.containsKey(s) && this.tokvok.get(s) != null) {
                LOGGER.debug("get {}", (Object)s);
                String tokvoc = this.tokvok.get(s);
                if (g instanceof InmemantlrGrammar) {
                    LOGGER.debug("import from {}", (Object)tokvoc);
                    ((InmemantlrGrammar)g).setTokenVocab(tokvoc);
                } else if (g instanceof InmemantlrLexerGrammar) {
                    LOGGER.debug("2");
                    ((InmemantlrLexerGrammar)g).setTokenVocab(tokvoc);
                }
            }
            if (this.isImported(g.name)) continue;
            this.process(p.getG());
            p.process();
            this.setParserLexer(p.getG());
            if (!p.hasTokenVocab()) continue;
            LOGGER.debug("put tokvok {}", (Object)g.name);
            this.tokvok.put(g.name, p.getTokenVocabString());
        }
        return new Tuple<String, String>(this.parserName, this.lexerName);
    }

    public String getDepTokVocName(Grammar g) {
        String ret = "";
        GrammarAST tokenVocabNode = InmemantlrTool.findOptionValueAST((GrammarRootAST)g.ast, (String)"tokenVocab");
        if (tokenVocabNode != null) {
            ret = tokenVocabNode.getText();
            LOGGER.debug("TOKENVOC {}", (Object)ret);
        }
        return ret;
    }

    public Set<StringCodeGenPipeline> getCompilationUnits() {
        return this.getPipelines().stream().filter(p -> !this.isImported(p.getG().name)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public void info(String msg) {
        LOGGER.debug("info");
        super.info(msg);
    }

    public void error(ANTLRMessage msg) {
        LOGGER.debug("error");
        super.error(msg);
    }

    public void warning(ANTLRMessage msg) {
        LOGGER.debug("warning");
        super.warning(msg);
    }

    public void version() {
        this.info("ANTLR Parser Generator  Version " + VERSION);
    }

    public void exit(int e) {
        System.exit(e);
    }

    public void processNonCombinedGrammar(Grammar g, boolean gencode) {
        boolean ruleFail;
        if (g.ast == null || g.ast.hasErrors) {
            return;
        }
        if (internalOption_PrintGrammarTree) {
            System.out.println(g.ast.toStringTree());
        }
        if (ruleFail = this.checkForRuleIssues(g)) {
            return;
        }
        int prevErrors = this.errMgr.getNumErrors();
        SemanticPipeline sem = new SemanticPipeline(g);
        sem.process();
        String language = g.getOptionString("language");
        if (!CodeGenerator.targetExists((String)language)) {
            this.errMgr.toolError(ErrorType.CANNOT_CREATE_TARGET_GENERATOR, new Object[]{language});
            return;
        }
        if (this.errMgr.getNumErrors() > prevErrors) {
            return;
        }
        Object factory = g.isLexer() ? new LexerATNFactory((LexerGrammar)g) : new ParserATNFactory(g);
        g.atn = factory.createATN();
        if (this.generate_ATN_dot) {
            this.generateATNs(g);
        }
        AnalysisPipeline anal = new AnalysisPipeline(g);
        anal.process();
        if (g.tool.getNumErrors() > prevErrors) {
            return;
        }
        if (gencode) {
            CodeGenPipeline gen = new CodeGenPipeline(g);
            gen.process();
        }
    }
}

