/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.tool;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.parse.TokenVocabParser;
import org.antlr.v4.tool.Grammar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTokenVocabParser
extends TokenVocabParser {
    private Scanner tv;
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryTokenVocabParser.class);

    public MemoryTokenVocabParser(Grammar g, String tokenVocab) {
        super(g);
        this.tv = new Scanner(tokenVocab);
    }

    public Map<String, Integer> load() {
        LinkedHashMap<String, Integer> tokens = new LinkedHashMap<String, Integer>();
        int maxTokenType = -1;
        String vocabName = this.g.getOptionString("tokenVocab");
        if (!this.tv.hasNextLine()) {
            return tokens;
        }
        Pattern tokenDefPattern = Pattern.compile("([^\n]+?)[ \\t]*?=[ \\t]*?([0-9]+)");
        int lineNum = 1;
        while (this.tv.hasNextLine()) {
            String tokenDef = this.tv.nextLine();
            Matcher matcher = tokenDefPattern.matcher(tokenDef);
            if (matcher.find()) {
                int tokenType;
                String tokenID = matcher.group(1);
                String tokenTypeS = matcher.group(2);
                try {
                    tokenType = Integer.valueOf(tokenTypeS);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error(vocabName + ".tokens", (Object)(" bad token type: " + tokenTypeS), (Object)lineNum);
                    tokenType = 0;
                    assert (false);
                    System.exit(-1);
                }
                tokens.put(tokenID, tokenType);
                maxTokenType = Math.max(maxTokenType, tokenType);
                ++lineNum;
                continue;
            }
            if (tokenDef.isEmpty()) continue;
            LOGGER.error(vocabName + ".tokens", (Object)(" bad token def: " + tokenDef), (Object)lineNum);
            assert (false);
            System.exit(-1);
        }
        return tokens;
    }
}

