/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.tree;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.tree.ParseTree;
import org.snt.inmemantlr.tree.ParseTreeNode;
import org.snt.inmemantlr.tree.ParseTreeProcessor;

public class JsonProcessor
extends ParseTreeProcessor<StringBuilder, StringBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonProcessor.class);
    private boolean idxOnly = false;

    public JsonProcessor(ParseTree parseTree, boolean idxOnly) {
        super(parseTree);
        this.idxOnly = idxOnly;
    }

    public JsonProcessor(ParseTree parseTree) {
        this(parseTree, true);
    }

    @Override
    public StringBuilder getResult() {
        return (StringBuilder)this.smap.get(this.parseTree.getRoot());
    }

    @Override
    protected void initialize() {
    }

    @Override
    protected void process(ParseTreeNode n) {
        StringBuilder sb = new StringBuilder();
        if (!n.hasParent()) {
            this.simpleProp(n);
            return;
        }
        sb.append("{");
        sb.append("\"nt\":\"");
        sb.append(n.getRule());
        sb.append("\",\"ran\":\"");
        sb.append(n.getSidx());
        sb.append(",");
        sb.append(n.getEidx());
        sb.append("\"");
        if (!this.idxOnly) {
            sb.append("\",\"lbl\":\"");
            sb.append(n.getEscapedLabel());
            sb.append("\"");
        }
        if (n.hasChildren()) {
            sb.append(",");
            sb.append("\"cld\":[");
            for (int i = 0; i < n.getChildren().size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append((CharSequence)this.smap.get(n.getChild(i)));
            }
            sb.append("]");
        }
        sb.append("}");
        this.smap.put(n, sb);
    }
}

