/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.snt.inmemantlr.tree.ParseTreeNode;
import org.snt.inmemantlr.tree.ParseTreeSerializer;

public class ParseTree {
    private final ParseTreeNode root;
    List<ParseTreeNode> nodes = new ArrayList<ParseTreeNode>();

    public ParseTree(String nt, String label) {
        this.root = this.newNode(null, nt, label, 0, 0, 0, 0);
    }

    public ParseTree(ParseTree tree) {
        this.root = this.newNode(tree.root);
    }

    private ParseTree(ParseTreeNode nod) {
        this.root = this.newNode(nod);
    }

    public ParseTreeNode getRoot() {
        return this.root;
    }

    private ParseTreeNode newNode(ParseTreeNode parent) {
        ParseTreeNode rn = new ParseTreeNode(this, parent);
        this.nodes.add(rn);
        return rn;
    }

    public ParseTreeNode newNode(ParseTreeNode parent, String nt, String label, int sidx, int eidx, int line, int charPositionInLine) {
        ParseTreeNode rn = new ParseTreeNode(this, parent, nt, label, sidx, eidx, line, charPositionInLine);
        this.nodes.add(rn);
        return rn;
    }

    public Set<ParseTreeNode> getLeafs() {
        return this.nodes.stream().filter(n -> !n.hasChildren()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public List<ParseTreeNode> getNodes() {
        return this.nodes;
    }

    public String toDot() {
        return ParseTreeSerializer.INSTANCE.toDot(this);
    }

    public String toJson() {
        return ParseTreeSerializer.INSTANCE.toJson(this);
    }

    public String toXml() {
        return ParseTreeSerializer.INSTANCE.toXml(this);
    }

    public boolean replaceSubtree(ParseTree oldTree, ParseTree newTree) {
        if (this.hasSubtree(oldTree)) {
            this.nodes.stream().filter(oldTree.root::equals).forEach(n -> n.getParent().replaceChild(oldTree.root, newTree.root));
            this.nodes.addAll(newTree.nodes);
            return this.nodes.removeAll(oldTree.nodes);
        }
        return false;
    }

    public boolean removeSubtree(ParseTree subtree) {
        if (this.hasSubtree(subtree)) {
            this.nodes.stream().filter(subtree.root::equals).forEach(n -> n.getParent().delChild((ParseTreeNode)n));
            return this.nodes.removeAll(subtree.nodes);
        }
        return false;
    }

    public Set<ParseTree> getDominatingSubtrees(Predicate<ParseTreeNode> p) {
        HashSet<ParseTreeNode> selected = new HashSet<ParseTreeNode>();
        this.searchDominatingNodes(this.root, selected, p);
        return this.getSubtrees(selected::contains);
    }

    private void searchDominatingNodes(ParseTreeNode n, Set<ParseTreeNode> selected, Predicate<ParseTreeNode> p) {
        if (p.test(n)) {
            selected.add(n);
        } else {
            n.getChildren().forEach(an -> this.searchDominatingNodes((ParseTreeNode)an, selected, p));
        }
    }

    public Set<ParseTree> getSubtrees(Predicate<ParseTreeNode> p) {
        return this.nodes.stream().filter(p).map(ParseTree::new).collect(Collectors.toSet());
    }

    public boolean hasSubtree(ParseTree subtree) {
        Set<ParseTree> subtrees = this.getSubtrees(subtree.root::equals);
        return subtrees.stream().anyMatch(subtree::equals);
    }

    public ParseTree getSubtree(ParseTree subtree) {
        Set<ParseTree> subtrees = this.getSubtrees(n -> n.equals(subtree.root));
        return subtrees.stream().filter(subtree::equals).findFirst().orElse(null);
    }

    public int hashCode() {
        return this.root.getId();
    }

    private void topoSortRec(List<ParseTreeNode> ns, ParseTreeNode n) {
        ns.add(n);
        for (ParseTreeNode cc : n.getChildren()) {
            this.topoSortRec(ns, cc);
        }
    }

    public void topoSort() {
        ArrayList<ParseTreeNode> nods = new ArrayList<ParseTreeNode>();
        this.topoSortRec(nods, this.root);
        assert (nods.size() == this.nodes.size());
        this.nodes = nods;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParseTree)) {
            return false;
        }
        ParseTree parseTree = (ParseTree)o;
        return this.root.equals(parseTree.root);
    }
}

