/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.tree;

import java.util.ArrayList;
import java.util.List;
import org.snt.inmemantlr.tree.ParseTree;
import org.snt.inmemantlr.utils.EscapeUtils;

public class ParseTreeNode {
    private String label;
    private String ntype;
    private ParseTreeNode parent;
    private ParseTree tree;
    private int id;
    private int sidx = 0;
    private int eidx = 0;
    private int line = 0;
    private int charPositionInLine = 0;
    private List<ParseTreeNode> children;
    private static int cnt = 0;

    private ParseTreeNode(ParseTree tree) {
        this.tree = tree;
        this.id = cnt++;
        this.children = new ArrayList<ParseTreeNode>();
    }

    protected ParseTreeNode(ParseTree tree, ParseTreeNode parent, String nt, String label, int sidx, int eidx, int line, int charPositionInLine) {
        this(tree);
        this.ntype = nt;
        this.label = label;
        this.parent = parent;
        this.sidx = sidx;
        this.eidx = eidx;
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    protected ParseTreeNode(ParseTree tree, ParseTreeNode nod) {
        this(tree);
        this.id = nod.id;
        this.ntype = nod.ntype;
        this.label = nod.label;
        this.eidx = nod.eidx;
        this.sidx = nod.sidx;
        this.line = nod.line;
        this.charPositionInLine = nod.charPositionInLine;
        for (ParseTreeNode c : nod.children) {
            ParseTreeNode cnod = new ParseTreeNode(tree, c);
            cnod.parent = this;
            this.tree.nodes.add(cnod);
            this.children.add(cnod);
        }
    }

    public ParseTreeNode getChild(int i) {
        if (i < 0 || i > this.children.size()) {
            throw new IllegalArgumentException("Index must be greater than or equal to zero and less than the children size");
        }
        return this.children.get(i);
    }

    public ParseTreeNode getLastChild() {
        if (!this.children.isEmpty()) {
            return this.children.get(this.children.size() - 1);
        }
        return null;
    }

    public ParseTreeNode getFirstChild() {
        if (!this.children.isEmpty()) {
            return this.children.get(0);
        }
        return null;
    }

    public void setParent(ParseTreeNode par) {
        this.parent = par;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public ParseTreeNode getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<ParseTreeNode> getChildren() {
        return this.children;
    }

    public void addChild(ParseTreeNode n) {
        this.children.add(n);
    }

    public void delChild(ParseTreeNode n) {
        this.children.remove(n);
    }

    public void replaceChild(ParseTreeNode oldNode, ParseTreeNode newNode) {
        if (this.children.contains(oldNode)) {
            this.children.set(this.children.indexOf(oldNode), newNode);
            newNode.parent = this;
        }
    }

    public int getId() {
        return this.id;
    }

    public String getRule() {
        return this.ntype;
    }

    public String getEscapedLabel() {
        return EscapeUtils.escapeSpecialCharacters(this.label);
    }

    public int getSidx() {
        return this.sidx;
    }

    public int getEidx() {
        return this.eidx;
    }

    public int getLine() {
        return this.line;
    }

    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public boolean isTerminal() {
        return this.isLeaf() && this.ntype.isEmpty();
    }

    public String getLabel() {
        return this.label;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParseTreeNode)) {
            return false;
        }
        ParseTreeNode n = (ParseTreeNode)o;
        return n.id == this.id && n.ntype.equals(this.ntype) && n.label.equals(this.label) && this.children.equals(n.children);
    }

    public String toString() {
        return this.id + " " + this.ntype + " " + this.label;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }
}

