/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.tree;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.snt.inmemantlr.exceptions.ParseTreeProcessorException;
import org.snt.inmemantlr.tree.ParseTree;
import org.snt.inmemantlr.tree.ParseTreeNode;

public abstract class ParseTreeProcessor<R, T> {
    protected ParseTree parseTree = null;
    protected Map<ParseTreeNode, T> smap;
    protected Queue<ParseTreeNode> active;
    private Map<ParseTreeNode, Integer> nmap;

    public ParseTreeProcessor(ParseTree parseTree) {
        this.parseTree = parseTree;
        this.nmap = new HashMap<ParseTreeNode, Integer>();
        this.smap = new HashMap<ParseTreeNode, T>();
        this.active = new ArrayDeque<ParseTreeNode>();
    }

    public R process() throws ParseTreeProcessorException {
        this.parseTree.topoSort();
        this.initialize();
        for (ParseTreeNode rn : this.parseTree.getNodes()) {
            this.nmap.put(rn, rn.getChildren().size());
        }
        this.active.addAll(this.parseTree.getLeafs());
        while (!this.active.isEmpty()) {
            ParseTreeNode rn = this.active.poll();
            this.process(rn);
            ParseTreeNode parent = rn.getParent();
            if (parent == null) continue;
            this.nmap.replace(parent, this.nmap.get(parent) - 1);
            if (this.nmap.get(parent) != 0) continue;
            this.active.add(parent);
        }
        return this.getResult();
    }

    public String debug() {
        StringBuilder sb = new StringBuilder();
        sb.append(".....Smap......\n");
        for (Map.Entry<ParseTreeNode, T> entry : this.smap.entrySet()) {
            sb.append(entry.getKey().getId()).append(" :: ").append(entry.getValue()).append("\n");
        }
        sb.append(".....Nmap......\n");
        for (Map.Entry<ParseTreeNode, Object> entry : this.nmap.entrySet()) {
            sb.append(entry.getKey().getId()).append(" :: ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public void simpleProp(ParseTreeNode n) {
        if (n.getChildren().size() == 1) {
            this.smap.put(n, this.smap.get(n.getFirstChild()));
        }
    }

    public T getElement(ParseTreeNode n) {
        if (!this.smap.containsKey(n)) {
            throw new IllegalArgumentException("smap must contain AstNode");
        }
        return this.smap.get(n);
    }

    public abstract R getResult();

    protected abstract void initialize();

    protected abstract void process(ParseTreeNode var1) throws ParseTreeProcessorException;
}

