/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.tree;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.exceptions.ParseTreeProcessorException;
import org.snt.inmemantlr.tree.JsonProcessor;
import org.snt.inmemantlr.tree.ParseTree;
import org.snt.inmemantlr.tree.ParseTreeNode;
import org.snt.inmemantlr.tree.XmlProcessor;

public enum ParseTreeSerializer {
    INSTANCE;

    private static final Logger LOGGER;

    private String getStringForEdge(ParseTreeNode c) {
        return "\tn" + c.getParent().getId() + " -- n" + c.getId() + ";\n";
    }

    private String getStringForNode(ParseTreeNode n) {
        StringBuilder sb = new StringBuilder();
        sb.append("\tn");
        sb.append(n.getId());
        sb.append(" [label=\"");
        if (n.isTerminal()) {
            sb.append(n.getEscapedLabel());
        } else {
            sb.append(n.getRule());
        }
        sb.append("\",");
        if (!n.isTerminal()) {
            sb.append("shape=ellipse");
        } else {
            sb.append("shape=box");
        }
        sb.append("];\n");
        return sb.toString();
    }

    public void toDotRec(StringBuilder sb, ParseTreeNode par) {
        sb.append(this.getStringForNode(par));
        for (ParseTreeNode cc : par.getChildren()) {
            this.toDotRec(sb, cc);
            sb.append(this.getStringForEdge(cc));
        }
    }

    public String toDot(ParseTree parseTree) {
        StringBuilder sb = new StringBuilder().append("graph {\n").append("\tnode [fontname=Helvetica,fontsize=11];\n").append("\tedge [fontname=Helvetica,fontsize=10];\n");
        this.toDotRec(sb, parseTree.getRoot());
        sb.append("}\n");
        return sb.toString();
    }

    public String toJson(ParseTree parseTree) {
        JsonProcessor jsonProc = new JsonProcessor(parseTree);
        StringBuilder sb = null;
        try {
            sb = (StringBuilder)jsonProc.process();
        }
        catch (ParseTreeProcessorException e) {
            LOGGER.error(e.getMessage());
            System.exit(-1);
        }
        return sb.toString();
    }

    public String toXml(ParseTree parseTree) {
        XmlProcessor xmlProc = new XmlProcessor(parseTree);
        StringBuilder sb = null;
        try {
            sb = (StringBuilder)xmlProc.process();
        }
        catch (ParseTreeProcessorException e) {
            LOGGER.error(e.getMessage());
            System.exit(-1);
        }
        return sb.toString();
    }

    static {
        LOGGER = LoggerFactory.getLogger(ParseTreeSerializer.class);
    }
}

